/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Set;
import org.opendaylight.ovsdb.lib.schema.BaseType;
import org.opendaylight.ovsdb.lib.schema.BaseTypeFactory;

final class StringBaseType
extends BaseType<StringBaseType> {
    static final StringBaseType SINGLETON = new StringBaseType(Integer.MIN_VALUE, Integer.MAX_VALUE, null);
    static final BaseTypeFactory<StringBaseType> FACTORY = new Factory();
    private final int minLength;
    private final int maxLength;
    private final ImmutableSet<String> enums;

    StringBaseType(int min, int max, ImmutableSet<String> enums) {
        this.minLength = min;
        this.maxLength = max;
        this.enums = enums;
    }

    @Override
    public Object toValue(JsonNode value) {
        return value.asText();
    }

    @Override
    public void validate(Object value) {
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public Set<String> getEnums() {
        return this.enums;
    }

    public String toString() {
        return "StringBaseType";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.enums == null ? 0 : this.enums.hashCode());
        result = 31 * result + this.maxLength;
        result = 31 * result + this.minLength;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringBaseType other = (StringBaseType)obj;
        if (this.enums == null ? other.enums != null : !this.enums.equals(other.enums)) {
            return false;
        }
        if (this.maxLength != other.maxLength) {
            return false;
        }
        return this.minLength == other.minLength;
    }

    private static final class Factory
    extends BaseTypeFactory<StringBaseType> {
        private Factory() {
        }

        @Override
        StringBaseType create(JsonNode typeDefinition) {
            JsonNode typeMaxNode = typeDefinition.get("maxLength");
            int max = typeMaxNode != null ? typeMaxNode.asInt() : Integer.MAX_VALUE;
            JsonNode typeMinNode = typeDefinition.get("minLength");
            int min = typeMinNode != null ? typeMinNode.asInt() : Integer.MIN_VALUE;
            JsonNode typeEnumNode = typeDefinition.get("enum");
            ImmutableSet<String> enums = typeEnumNode != null ? Factory.parseEnums(typeEnumNode) : null;
            return min == Integer.MIN_VALUE && max == Integer.MAX_VALUE && enums == null ? SINGLETON : new StringBaseType(min, max, enums);
        }

        private static ImmutableSet<String> parseEnums(JsonNode enumVal) {
            if (enumVal.isTextual()) {
                return ImmutableSet.of((Object)enumVal.asText());
            }
            if (enumVal.isArray()) {
                ArrayList<String> tmp = new ArrayList<String>();
                JsonNode anEnum = enumVal.get(1);
                for (JsonNode enm : anEnum) {
                    tmp.add(enm.asText());
                }
                return ImmutableSet.copyOf(tmp);
            }
            return ImmutableSet.of();
        }
    }
}

