/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.ovsdb.lib.message.TableUpdate;
import org.opendaylight.ovsdb.lib.notation.Column;
import org.opendaylight.ovsdb.lib.notation.Row;
import org.opendaylight.ovsdb.lib.notation.UUID;
import org.opendaylight.ovsdb.lib.operations.Insert;
import org.opendaylight.ovsdb.lib.schema.AtomicColumnType;
import org.opendaylight.ovsdb.lib.schema.ColumnSchema;
import org.opendaylight.ovsdb.lib.schema.ColumnType;
import org.opendaylight.ovsdb.lib.schema.UuidBaseType;
import org.opendaylight.yangtools.util.CollectionWrappers;

public abstract class TableSchema<E extends TableSchema<E>> {
    private static final AtomicColumnType UUID_COLUMN_TYPE = new AtomicColumnType(UuidBaseType.SINGLETON);
    protected static final ColumnSchema UUID_COLUMN_SCHMEMA = new ColumnSchema("_uuid", UUID_COLUMN_TYPE);
    protected static final ColumnSchema VERSION_COLUMN_SCHMEMA = new ColumnSchema("_version", UUID_COLUMN_TYPE);
    private final String name;
    private final ImmutableMap<String, ColumnSchema> columns;
    private volatile List<String> columnList;

    protected TableSchema(String name) {
        this(name, (Map<String, ColumnSchema>)ImmutableMap.of());
    }

    protected TableSchema(String name, Map<String, ColumnSchema> columns) {
        this.name = Objects.requireNonNull(name);
        this.columns = ImmutableMap.copyOf(columns);
    }

    public Set<String> getColumns() {
        return this.columns.keySet();
    }

    public List<String> getColumnList() {
        List<String> local = this.columnList;
        return local != null ? local : this.populateColumnList();
    }

    private synchronized List<String> populateColumnList() {
        List local = this.columnList;
        if (local == null) {
            this.columnList = local = CollectionWrappers.wrapAsList((Collection)this.columns.keySet());
        }
        return local;
    }

    public Map<String, ColumnSchema> getColumnSchemas() {
        return this.columns;
    }

    public boolean hasColumn(String column) {
        return this.columns.containsKey((Object)column);
    }

    public ColumnType getColumnType(String column) {
        return ((ColumnSchema)this.columns.get((Object)column)).getType();
    }

    public <E extends TableSchema<E>> E as(Class<E> clazz) {
        try {
            Constructor<E> instance = clazz.getConstructor(TableSchema.class);
            return (E)((TableSchema)instance.newInstance(this));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("exception constructing instance of clazz " + clazz, e);
        }
    }

    public Insert<E> insert() {
        return new Insert(this);
    }

    public <D> ColumnSchema<E, Set<D>> multiValuedColumn(String column, Class<D> type) {
        ColumnSchema columnSchema = (ColumnSchema)this.columns.get((Object)column);
        columnSchema.validateType(type);
        return columnSchema;
    }

    public <K, V> ColumnSchema<E, Map<K, V>> multiValuedColumn(String column, Class<K> keyType, Class<V> valueType) {
        ColumnSchema columnSchema = (ColumnSchema)this.columns.get((Object)column);
        columnSchema.validateType(valueType);
        return columnSchema;
    }

    public <D> ColumnSchema<E, D> column(String column, Class<D> type) {
        ColumnSchema columnSchema = (ColumnSchema)this.columns.get((Object)column);
        if (columnSchema != null) {
            columnSchema.validateType(type);
        }
        return columnSchema;
    }

    public ColumnSchema column(String column) {
        return (ColumnSchema)this.columns.get((Object)column);
    }

    public String getName() {
        return this.name;
    }

    public TableUpdate<E> updatesFromJson(JsonNode value) {
        TableUpdate<E> tableUpdate = new TableUpdate<E>();
        Iterator fields = value.fields();
        while (fields.hasNext()) {
            Map.Entry idOldNew = (Map.Entry)fields.next();
            String uuid = (String)idOldNew.getKey();
            ObjectNode newObjectNode = (ObjectNode)((JsonNode)idOldNew.getValue()).get("new");
            ObjectNode oldObjectNode = (ObjectNode)((JsonNode)idOldNew.getValue()).get("old");
            Row<E> newRow = newObjectNode != null ? this.createRow(newObjectNode) : null;
            Row<E> oldRow = oldObjectNode != null ? this.createRow(oldObjectNode) : null;
            tableUpdate.addRow(new UUID(uuid), oldRow, newRow);
        }
        return tableUpdate;
    }

    public Row<E> createRow(ObjectNode rowNode) {
        ArrayList newColumns = new ArrayList();
        Iterator iter = rowNode.fields();
        while (iter.hasNext()) {
            Map.Entry next = (Map.Entry)iter.next();
            ColumnSchema<E, Object> schema = this.column((String)next.getKey(), Object.class);
            if (schema == null) continue;
            Object value = schema.valueFromJson((JsonNode)next.getValue());
            newColumns.add(new Column<E, Object>(schema, value));
        }
        return new Row(this, newColumns);
    }

    public List<Row<E>> createRows(JsonNode rowsNode) {
        ArrayList<Row<Row<E>>> rows = new ArrayList<Row<Row<E>>>();
        for (JsonNode rowNode : rowsNode.get("rows")) {
            rows.add(this.createRow((ObjectNode)rowNode));
        }
        return rows;
    }

    public abstract E withInternallyGeneratedColumns();

    protected final boolean haveInternallyGeneratedColumns() {
        return this.hasColumn(UUID_COLUMN_SCHMEMA.getName()) && this.hasColumn(VERSION_COLUMN_SCHMEMA.getName());
    }
}

