/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.schema;

import com.fasterxml.jackson.databind.JsonNode;
import org.opendaylight.ovsdb.lib.notation.ReferencedRow;
import org.opendaylight.ovsdb.lib.notation.UUID;
import org.opendaylight.ovsdb.lib.schema.BaseType;
import org.opendaylight.ovsdb.lib.schema.BaseTypeFactory;

final class UuidBaseType
extends BaseType<UuidBaseType> {
    static final UuidBaseType SINGLETON = new UuidBaseType(null, null);
    static final BaseTypeFactory<UuidBaseType> FACTORY = new BaseTypeFactory<UuidBaseType>(){

        @Override
        UuidBaseType create(JsonNode typeDefinition) {
            JsonNode refTableNode = typeDefinition.get("refTable");
            String refTable = refTableNode != null ? refTableNode.asText() : null;
            JsonNode refTypeJson = typeDefinition.get("refType");
            RefType refType = refTypeJson != null ? RefType.valueOf(refTypeJson.asText()) : RefType.strong;
            return new UuidBaseType(refTable, refType);
        }
    };
    private final String refTable;
    private final RefType refType;

    UuidBaseType(String refTable, RefType refType) {
        this.refTable = refTable;
        this.refType = refType;
    }

    @Override
    public Object toValue(JsonNode value) {
        if (value.isArray()) {
            if (value.size() == 2 && value.get(0).isTextual() && "uuid".equals(value.get(0).asText())) {
                return new UUID(value.get(1).asText());
            }
        } else {
            return new ReferencedRow(this.refTable, value);
        }
        return null;
    }

    @Override
    public void validate(Object value) {
    }

    public String getRefTable() {
        return this.refTable;
    }

    public RefType getRefType() {
        return this.refType;
    }

    public String toString() {
        return "UuidBaseType";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.refTable == null ? 0 : this.refTable.hashCode());
        result = 31 * result + (this.refType == null ? 0 : this.refType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UuidBaseType other = (UuidBaseType)obj;
        if (this.refTable == null ? other.refTable != null : !this.refTable.equals(other.refTable)) {
            return false;
        }
        return this.refType == other.refType;
    }

    public static enum RefType {
        strong,
        weak;

    }
}

