/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.schema.typed;

import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.ovsdb.lib.error.ColumnSchemaNotFoundException;
import org.opendaylight.ovsdb.lib.error.SchemaVersionMismatchException;
import org.opendaylight.ovsdb.lib.error.TableSchemaNotFoundException;
import org.opendaylight.ovsdb.lib.error.TyperException;
import org.opendaylight.ovsdb.lib.notation.Row;
import org.opendaylight.ovsdb.lib.notation.Version;
import org.opendaylight.ovsdb.lib.schema.ColumnSchema;
import org.opendaylight.ovsdb.lib.schema.DatabaseSchema;
import org.opendaylight.ovsdb.lib.schema.GenericTableSchema;
import org.opendaylight.ovsdb.lib.schema.typed.GetColumn;
import org.opendaylight.ovsdb.lib.schema.typed.GetData;
import org.opendaylight.ovsdb.lib.schema.typed.GetRow;
import org.opendaylight.ovsdb.lib.schema.typed.GetTable;
import org.opendaylight.ovsdb.lib.schema.typed.MethodType;
import org.opendaylight.ovsdb.lib.schema.typed.SetData;
import org.opendaylight.ovsdb.lib.schema.typed.TypedColumn;
import org.opendaylight.ovsdb.lib.schema.typed.TypedDatabaseSchema;
import org.opendaylight.ovsdb.lib.schema.typed.TypedReflections;
import org.opendaylight.ovsdb.lib.schema.typed.TypedRowInvocationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MethodDispatch {
    private static final LoadingCache<Class<?>, MethodDispatch> CACHE = CacheBuilder.newBuilder().weakKeys().weakValues().build(new CacheLoader<Class<?>, MethodDispatch>(){

        public MethodDispatch load(Class<?> key) {
            return new MethodDispatch(key);
        }
    });
    private final @NonNull ImmutableMap<Method, Prototype> prototypes;
    private final @NonNull String tableName;

    private MethodDispatch(Class<?> key) {
        this.tableName = TypedReflections.getTableName(key);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Method method : key.getMethods()) {
            Prototype prototype = MethodDispatch.prototypeFor(this.tableName, method);
            if (prototype == null) continue;
            builder.put((Object)method, (Object)prototype);
        }
        this.prototypes = builder.build();
    }

    static MethodDispatch forTarget(Class<?> target) {
        return (MethodDispatch)CACHE.getUnchecked(target);
    }

    @NonNull TypedRowInvocationHandler bindToSchema(TypedDatabaseSchema dbSchema) {
        return new TypedRowInvocationHandler(this.tableName, (ImmutableMap<Method, Invoker>)ImmutableMap.copyOf((Map)Maps.transformValues(this.prototypes, prototype -> prototype.bindTo(dbSchema))));
    }

    private static @Nullable Prototype prototypeFor(String tableName, Method method) {
        TypedColumn typedColumn = method.getAnnotation(TypedColumn.class);
        if (typedColumn != null) {
            MethodType methodType = typedColumn.method();
            switch (methodType) {
                case GETCOLUMN: {
                    return new GetColumn(method, tableName, typedColumn.name());
                }
                case GETDATA: {
                    return new GetData(method, tableName, typedColumn.name());
                }
                case GETROW: {
                    return GetRow.INSTANCE;
                }
                case GETTABLESCHEMA: {
                    return new GetTable(tableName);
                }
                case SETDATA: {
                    return new SetData(method, tableName, typedColumn.name());
                }
            }
            throw new TyperException("Unhandled method type " + methodType);
        }
        String name = method.getName();
        if (name.startsWith("set")) {
            return new SetData(method, MethodDispatch.accessorName(name.substring(3)), tableName);
        }
        if (name.startsWith("get")) {
            if (name.endsWith("Row")) {
                return GetRow.INSTANCE;
            }
            String tail = name.substring(3);
            if (tail.endsWith("Column")) {
                return new GetColumn(method, tableName, MethodDispatch.accessorName(tail.substring(0, tail.length() - 6)));
            }
            return new GetData(method, MethodDispatch.accessorName(tail), tableName);
        }
        return null;
    }

    private static String accessorName(String columnName) {
        return columnName.toLowerCase(Locale.ROOT);
    }

    static abstract class Prototype {
        Prototype() {
        }

        abstract Invoker bindTo(TypedDatabaseSchema var1);
    }

    static abstract class Invoker {
        Invoker() {
        }

        abstract Object invokeMethod(Row<GenericTableSchema> var1, Object var2, Object[] var3);
    }

    static abstract class StrictColumnPrototype<T>
    extends ColumnPrototype<T> {
        StrictColumnPrototype(Method method, String tableName, String columnName) {
            super(method, method.getReturnType(), tableName, columnName);
        }

        @Override
        final Invoker bindToImpl(@NonNull GenericTableSchema tableSchema) {
            ColumnSchema columnSchema = this.findColumnSchema(tableSchema);
            return columnSchema != null ? this.bindToImpl(tableSchema, columnSchema) : this.columnSchemaNotFound(tableSchema);
        }

        abstract Invoker bindToImpl(@NonNull GenericTableSchema var1, @NonNull ColumnSchema<GenericTableSchema, T> var2);
    }

    static abstract class ColumnPrototype<T>
    extends TablePrototype {
        private static final Logger LOG = LoggerFactory.getLogger(ColumnPrototype.class);
        private final @NonNull Class<T> columnType;
        private final @NonNull String columnName;

        ColumnPrototype(Method method, Class<?> columnType, String tableName, String columnName) {
            super(TypedReflections.getColumnVersionRange(method), tableName);
            this.columnName = Objects.requireNonNull(columnName);
            this.columnType = Objects.requireNonNull(columnType);
        }

        final @NonNull String columnName() {
            return this.columnName;
        }

        final @Nullable ColumnSchema<GenericTableSchema, T> findColumnSchema(@NonNull GenericTableSchema tableSchema) {
            return tableSchema.column(this.columnName, this.columnType);
        }

        final @NonNull FailedInvoker columnSchemaNotFound(@NonNull GenericTableSchema tableSchema) {
            final String tableName = tableSchema.getName();
            LOG.debug("Failed to find schema for column {} in {}, deferring failure to invocation time", (Object)this.columnName, (Object)tableName);
            return new FailedInvoker(){

                @Override
                RuntimeException newException() {
                    return new ColumnSchemaNotFoundException(columnName, tableName);
                }
            };
        }

        @Override
        final Invoker bindToImpl(TypedDatabaseSchema dbSchema) {
            GenericTableSchema tableSchema = this.findTableSchema(dbSchema);
            return tableSchema != null ? this.bindToImpl(tableSchema) : this.tableSchemaNotFound(dbSchema);
        }

        abstract Invoker bindToImpl(@NonNull GenericTableSchema var1);
    }

    static abstract class TablePrototype
    extends VersionedPrototype {
        private static final Logger LOG = LoggerFactory.getLogger(TablePrototype.class);
        private final String tableName;

        TablePrototype(Range<Version> supportedVersions, String tableName) {
            super(supportedVersions);
            this.tableName = Objects.requireNonNull(tableName);
        }

        final @Nullable GenericTableSchema findTableSchema(DatabaseSchema dbSchema) {
            return dbSchema.table(this.tableName, GenericTableSchema.class);
        }

        final @NonNull FailedInvoker tableSchemaNotFound(DatabaseSchema dbSchema) {
            final String dbName = dbSchema.getName();
            LOG.debug("Failed to find schema for table {} in {}, deferring failure to invocation time", (Object)this.tableName, (Object)dbName);
            return new FailedInvoker(){

                @Override
                RuntimeException newException() {
                    return new TableSchemaNotFoundException(tableName, dbName);
                }
            };
        }
    }

    private static abstract class VersionedPrototype
    extends Prototype {
        private static final Logger LOG = LoggerFactory.getLogger(VersionedPrototype.class);
        private final Range<Version> supportedVersions;

        VersionedPrototype(Range<Version> supportedVersions) {
            this.supportedVersions = Objects.requireNonNull(supportedVersions);
        }

        @Override
        final Invoker bindTo(TypedDatabaseSchema dbSchema) {
            final Version version = dbSchema.getVersion();
            if (this.supportedVersions.contains((Comparable)version)) {
                return this.bindToImpl(dbSchema);
            }
            LOG.debug("Version {} does not match required range {}, deferring failure to invocation time", (Object)version, this.supportedVersions);
            return new FailedInvoker(){

                @Override
                RuntimeException newException() {
                    return new SchemaVersionMismatchException(version, supportedVersions);
                }
            };
        }

        abstract Invoker bindToImpl(TypedDatabaseSchema var1);
    }

    static abstract class ColumnInvoker<T>
    extends TableInvoker {
        private final ColumnSchema<GenericTableSchema, T> columnSchema;

        ColumnInvoker(GenericTableSchema tableSchema, ColumnSchema<GenericTableSchema, T> columnSchema) {
            super(Objects.requireNonNull(tableSchema));
            this.columnSchema = columnSchema;
        }

        @Override
        final @NonNull GenericTableSchema tableSchema() {
            return (GenericTableSchema)Verify.verifyNotNull((Object)super.tableSchema());
        }

        @Nullable ColumnSchema<GenericTableSchema, T> columnSchema() {
            return this.columnSchema;
        }

        @Override
        Object invokeMethod(Row<GenericTableSchema> row, Object proxy, Object[] args) {
            return row == null ? this.invokeMethod(proxy, args) : this.invokeRowMethod(row, proxy, args);
        }

        abstract Object invokeMethod(Object var1, Object[] var2);

        abstract Object invokeRowMethod(@NonNull Row<GenericTableSchema> var1, Object var2, Object[] var3);
    }

    static abstract class TableInvoker
    extends Invoker {
        private final GenericTableSchema tableSchema;

        TableInvoker(GenericTableSchema tableSchema) {
            this.tableSchema = tableSchema;
        }

        @Nullable GenericTableSchema tableSchema() {
            return this.tableSchema;
        }
    }

    static abstract class FailedInvoker
    extends Invoker {
        FailedInvoker() {
        }

        @Override
        @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_RUNTIMEEXCEPTION"}, justification="Polymorphic throw")
        final Object invokeMethod(Row<GenericTableSchema> row, Object proxy, Object[] args) {
            throw this.newException();
        }

        abstract @NonNull RuntimeException newException();
    }
}

