/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.schema.typed;

import java.lang.reflect.Method;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.ovsdb.lib.error.TyperException;
import org.opendaylight.ovsdb.lib.notation.Column;
import org.opendaylight.ovsdb.lib.notation.Row;
import org.opendaylight.ovsdb.lib.schema.ColumnSchema;
import org.opendaylight.ovsdb.lib.schema.GenericTableSchema;
import org.opendaylight.ovsdb.lib.schema.typed.MethodDispatch;

final class SetData<T>
extends MethodDispatch.ColumnPrototype<T> {
    SetData(Method method, String tableName, String columnName) {
        super(method, SetData.findTarget(method), tableName, columnName);
    }

    @Override
    Invoker<T> bindToImpl(GenericTableSchema tableSchema) {
        return new Invoker(tableSchema, this.columnName(), this.findColumnSchema(tableSchema));
    }

    private static Class<?> findTarget(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length != 1) {
            throw new TyperException("Setter method : " + method.getName() + " requires 1 argument");
        }
        return paramTypes[0];
    }

    private static final class Invoker<T>
    extends MethodDispatch.ColumnInvoker<T> {
        private final @NonNull String columnName;

        Invoker(@NonNull GenericTableSchema tableSchema, @NonNull String columnName, ColumnSchema<GenericTableSchema, T> columnSchema) {
            super(tableSchema, columnSchema);
            this.columnName = Objects.requireNonNull(columnName);
        }

        @Override
        Object invokeMethod(Object proxy, Object[] args) {
            throw new UnsupportedOperationException("No backing row supplied");
        }

        @Override
        Object invokeRowMethod(Row<GenericTableSchema> row, Object proxy, Object[] args) {
            row.addColumn(this.columnName, new Column<GenericTableSchema, Object>(this.columnSchema(), args[0]));
            return proxy;
        }
    }
}

