/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.schema.typed;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.reflect.Reflection;
import java.lang.reflect.InvocationHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.ovsdb.lib.message.TableUpdate;
import org.opendaylight.ovsdb.lib.message.TableUpdates;
import org.opendaylight.ovsdb.lib.notation.Row;
import org.opendaylight.ovsdb.lib.notation.UUID;
import org.opendaylight.ovsdb.lib.schema.DatabaseSchema;
import org.opendaylight.ovsdb.lib.schema.ForwardingDatabaseSchema;
import org.opendaylight.ovsdb.lib.schema.GenericTableSchema;
import org.opendaylight.ovsdb.lib.schema.typed.MethodDispatch;
import org.opendaylight.ovsdb.lib.schema.typed.TypedBaseTable;
import org.opendaylight.ovsdb.lib.schema.typed.TypedDatabaseSchema;
import org.opendaylight.ovsdb.lib.schema.typed.TypedReflections;
import org.opendaylight.ovsdb.lib.schema.typed.TypedRowInvocationHandler;
import org.opendaylight.ovsdb.lib.schema.typed.TyperUtils;

final class TypedDatabaseSchemaImpl
extends ForwardingDatabaseSchema
implements TypedDatabaseSchema {
    private final LoadingCache<Class<?>, TypedRowInvocationHandler> handlers = CacheBuilder.newBuilder().weakKeys().weakValues().build(new CacheLoader<Class<?>, TypedRowInvocationHandler>(){

        public TypedRowInvocationHandler load(Class<?> key) {
            return MethodDispatch.forTarget(key).bindToSchema(TypedDatabaseSchemaImpl.this);
        }
    });
    private final DatabaseSchema delegate;

    TypedDatabaseSchemaImpl(DatabaseSchema delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    protected DatabaseSchema delegate() {
        return this.delegate;
    }

    @Override
    public TypedDatabaseSchema withInternallyGeneratedColumns() {
        DatabaseSchema newDelegate = this.delegate.withInternallyGeneratedColumns();
        return newDelegate == this.delegate ? this : new TypedDatabaseSchemaImpl(newDelegate);
    }

    @Override
    public GenericTableSchema getTableSchema(Class<?> klazz) {
        return this.getTableSchema(TypedReflections.getTableName(klazz));
    }

    private GenericTableSchema getTableSchema(String tableName) {
        return this.table(tableName, GenericTableSchema.class);
    }

    @Override
    public <T extends TypedBaseTable<?>> T getTypedRowWrapper(Class<T> klazz, Row<GenericTableSchema> row) {
        String dbName = TypedReflections.getTableDatabase(klazz);
        if (dbName != null && !dbName.equalsIgnoreCase(this.getName())) {
            return null;
        }
        TyperUtils.checkVersion(this.getVersion(), TypedReflections.getTableVersionRange(klazz));
        TypedRowInvocationHandler handler = (TypedRowInvocationHandler)this.handlers.getUnchecked(klazz);
        if (row != null) {
            row.setTableSchema(this.getTableSchema(handler.getTableName()));
            handler = handler.bindToRow(row);
        }
        return (T)((TypedBaseTable)Reflection.newProxy(klazz, (InvocationHandler)handler));
    }

    @Override
    public <T extends TypedBaseTable<?>> Map<UUID, T> extractRowsOld(Class<T> klazz, TableUpdates updates) {
        HashMap<UUID, T> result = new HashMap<UUID, T>();
        for (TableUpdate.RowUpdate<GenericTableSchema> rowUpdate : this.extractRowUpdates(klazz, updates).values()) {
            if (rowUpdate == null || rowUpdate.getOld() == null) continue;
            Row<GenericTableSchema> row = rowUpdate.getOld();
            result.put(rowUpdate.getUuid(), this.getTypedRowWrapper(klazz, row));
        }
        return result;
    }

    @Override
    public <T extends TypedBaseTable<?>> Map<UUID, T> extractRowsUpdated(Class<T> klazz, TableUpdates updates) {
        HashMap<UUID, T> result = new HashMap<UUID, T>();
        for (TableUpdate.RowUpdate<GenericTableSchema> rowUpdate : this.extractRowUpdates(klazz, updates).values()) {
            if (rowUpdate == null || rowUpdate.getNew() == null) continue;
            result.put(rowUpdate.getUuid(), this.getTypedRowWrapper(klazz, rowUpdate.getNew()));
        }
        return result;
    }

    @Override
    public <T extends TypedBaseTable<?>> Map<UUID, T> extractRowsRemoved(Class<T> klazz, TableUpdates updates) {
        HashMap<UUID, T> result = new HashMap<UUID, T>();
        for (TableUpdate.RowUpdate<GenericTableSchema> rowUpdate : this.extractRowUpdates(klazz, updates).values()) {
            if (rowUpdate == null || rowUpdate.getNew() != null || rowUpdate.getOld() == null) continue;
            result.put(rowUpdate.getUuid(), this.getTypedRowWrapper(klazz, rowUpdate.getOld()));
        }
        return result;
    }

    private Map<UUID, TableUpdate.RowUpdate<GenericTableSchema>> extractRowUpdates(Class<?> klazz, TableUpdates updates) {
        Map<UUID, TableUpdate.RowUpdate<GenericTableSchema>> rows;
        TableUpdate<GenericTableSchema> update = updates.getUpdate(this.table(TypedReflections.getTableName(klazz), GenericTableSchema.class));
        Map<UUID, TableUpdate.RowUpdate<GenericTableSchema>> result = new HashMap<UUID, TableUpdate.RowUpdate<GenericTableSchema>>();
        if (update != null && (rows = update.getRows()) != null) {
            result = rows;
        }
        return result;
    }
}

