/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.schema.typed;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Range;
import java.lang.reflect.Method;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.ovsdb.lib.notation.Version;
import org.opendaylight.ovsdb.lib.schema.typed.TypedColumn;
import org.opendaylight.ovsdb.lib.schema.typed.TypedTable;

public final class TypedReflections {
    private static final LoadingCache<Method, Range<Version>> COLUMN_VERSIONS = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Method, Range<Version>>(){

        public Range<Version> load(Method key) {
            TypedColumn typedColumn = key.getAnnotation(TypedColumn.class);
            return typedColumn == null ? Range.all() : TypedReflections.createVersionRange(typedColumn.fromVersion(), typedColumn.untilVersion());
        }
    });
    private static final LoadingCache<Class<?>, Range<Version>> TABLE_VERSIONS = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, Range<Version>>(){

        public Range<Version> load(Class<?> key) {
            TypedTable typedTable = key.getAnnotation(TypedTable.class);
            return typedTable == null ? Range.all() : TypedReflections.createVersionRange(typedTable.fromVersion(), typedTable.untilVersion());
        }
    });

    private TypedReflections() {
    }

    public static @Nullable String getTableDatabase(Class<?> type) {
        TypedTable typedTable = type.getAnnotation(TypedTable.class);
        return typedTable != null ? typedTable.database() : null;
    }

    public static @NonNull String getTableName(Class<?> type) {
        TypedTable typedTable = type.getAnnotation(TypedTable.class);
        return typedTable != null ? typedTable.name() : type.getSimpleName();
    }

    public static @NonNull Range<Version> getTableVersionRange(Class<?> type) {
        return (Range)TABLE_VERSIONS.getUnchecked(type);
    }

    public static @NonNull Range<Version> getColumnVersionRange(Method method) {
        return (Range)COLUMN_VERSIONS.getUnchecked((Object)method);
    }

    static Range<Version> createVersionRange(String from, String until) {
        return Version.createRangeOf(from == null ? Version.NULL : Version.fromString(from), until == null ? Version.NULL : Version.fromString(until));
    }
}

