/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.schema.typed;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.ovsdb.lib.error.UnsupportedMethodException;
import org.opendaylight.ovsdb.lib.notation.Row;
import org.opendaylight.ovsdb.lib.schema.GenericTableSchema;
import org.opendaylight.ovsdb.lib.schema.typed.MethodDispatch;
import org.opendaylight.ovsdb.lib.schema.typed.TypedBaseTable;

final class TypedRowInvocationHandler
implements InvocationHandler {
    private final @NonNull ImmutableMap<Method, MethodDispatch.Invoker> invokers;
    private final @NonNull String tableName;
    private final @Nullable Row<GenericTableSchema> row;

    private TypedRowInvocationHandler(@NonNull String tableName, @NonNull ImmutableMap<Method, MethodDispatch.Invoker> invokers, Row<GenericTableSchema> row) {
        this.tableName = Objects.requireNonNull(tableName);
        this.invokers = Objects.requireNonNull(invokers);
        this.row = row;
    }

    TypedRowInvocationHandler(@NonNull String tableName, @NonNull ImmutableMap<Method, MethodDispatch.Invoker> invokers) {
        this(tableName, invokers, null);
    }

    TypedRowInvocationHandler bindToRow(@Nullable Row<GenericTableSchema> newRow) {
        return this.row == newRow ? this : new TypedRowInvocationHandler(this.tableName, this.invokers, newRow);
    }

    String getTableName() {
        return this.tableName;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        MethodDispatch.Invoker invoker = (MethodDispatch.Invoker)this.invokers.get((Object)method);
        return invoker != null ? invoker.invokeMethod(this.row, proxy, args) : this.invokeObjectMethod(proxy, method, args);
    }

    private Object invokeObjectMethod(Object proxy, Method method, Object[] args) {
        switch (method.getName()) {
            case "hashCode": {
                if (args != null && args.length != 0) break;
                return this.row == null ? 0 : this.row.hashCode();
            }
            case "equals": {
                if (args == null || args.length != 1 || method.getParameterTypes()[0] != Object.class) break;
                Object obj = args[0];
                return proxy == obj || proxy.getClass().isInstance(obj) && obj instanceof TypedBaseTable && Objects.equals(this.row, ((TypedBaseTable)obj).getRow());
            }
            case "toString": {
                if (args != null && args.length != 0) break;
                return this.row == null ? this.tableName : this.tableName + " : " + this.row.toString();
            }
        }
        throw new UnsupportedMethodException("Method not supported " + method.toString());
    }
}

