/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.schema.typed;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Range;
import java.util.Map;
import org.opendaylight.ovsdb.lib.error.SchemaVersionMismatchException;
import org.opendaylight.ovsdb.lib.message.TableUpdates;
import org.opendaylight.ovsdb.lib.notation.Row;
import org.opendaylight.ovsdb.lib.notation.UUID;
import org.opendaylight.ovsdb.lib.notation.Version;
import org.opendaylight.ovsdb.lib.schema.DatabaseSchema;
import org.opendaylight.ovsdb.lib.schema.GenericTableSchema;
import org.opendaylight.ovsdb.lib.schema.typed.TypedBaseTable;
import org.opendaylight.ovsdb.lib.schema.typed.TypedDatabaseSchema;
import org.opendaylight.ovsdb.lib.schema.typed.TypedDatabaseSchemaImpl;

public final class TyperUtils {
    private static final LoadingCache<DatabaseSchema, TypedDatabaseSchema> TYPED_CACHE = CacheBuilder.newBuilder().weakKeys().weakValues().build((CacheLoader)new CacheLoader<DatabaseSchema, TypedDatabaseSchema>(){

        public TypedDatabaseSchema load(DatabaseSchema key) {
            return new TypedDatabaseSchemaImpl(key);
        }
    });

    private TyperUtils() {
    }

    @Deprecated
    public static GenericTableSchema getTableSchema(DatabaseSchema dbSchema, Class<?> klazz) {
        return TyperUtils.getTyped(dbSchema).getTableSchema(klazz);
    }

    static void checkVersion(Version schemaVersion, Range<Version> range) {
        if (!range.contains((Comparable)schemaVersion)) {
            throw new SchemaVersionMismatchException(schemaVersion, range);
        }
    }

    @Deprecated
    public static <T extends TypedBaseTable<?>> T getTypedRowWrapper(DatabaseSchema dbSchema, Class<T> klazz) {
        return TyperUtils.getTypedRowWrapper(dbSchema, klazz, new Row<GenericTableSchema>());
    }

    @Deprecated
    public static <T extends TypedBaseTable<?>> T getTypedRowWrapper(DatabaseSchema dbSchema, Class<T> klazz, Row<GenericTableSchema> row) {
        return dbSchema == null ? null : (T)TyperUtils.getTyped(dbSchema).getTypedRowWrapper(klazz, row);
    }

    public static <T extends TypedBaseTable<?>> Map<UUID, T> extractRowsUpdated(Class<T> klazz, TableUpdates updates, DatabaseSchema dbSchema) {
        return TyperUtils.getTyped(dbSchema).extractRowsUpdated(klazz, updates);
    }

    public static <T extends TypedBaseTable<?>> Map<UUID, T> extractRowsOld(Class<T> klazz, TableUpdates updates, DatabaseSchema dbSchema) {
        return TyperUtils.getTyped(dbSchema).extractRowsOld(klazz, updates);
    }

    public static <T extends TypedBaseTable<?>> Map<UUID, T> extractRowsRemoved(Class<T> klazz, TableUpdates updates, DatabaseSchema dbSchema) {
        return TyperUtils.getTyped(dbSchema).extractRowsRemoved(klazz, updates);
    }

    private static TypedDatabaseSchema getTyped(DatabaseSchema dbSchema) {
        return dbSchema instanceof TypedDatabaseSchema ? (TypedDatabaseSchema)dbSchema : (TypedDatabaseSchema)TYPED_CACHE.getUnchecked((Object)dbSchema);
    }
}

