/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.utils.ovsdb.it.utils;

import java.util.List;
import org.junit.Assert;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.ovsdb.utils.mdsal.utils.MdsalUtils;
import org.opendaylight.ovsdb.utils.mdsal.utils.NotifyingDataChangeListener;
import org.opendaylight.ovsdb.utils.ovsdb.it.utils.NodeInfo;
import org.opendaylight.ovsdb.utils.southbound.utils.SouthboundUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.OvsdbBridgeAugmentation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.bridge.attributes.ControllerEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.ConnectionInfo;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OvsdbItUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OvsdbItUtils.class);
    MdsalUtils mdsalUtils;
    SouthboundUtils southboundUtils;
    DataBroker dataBroker;

    public OvsdbItUtils(DataBroker dataBroker) {
        this.dataBroker = dataBroker;
        this.mdsalUtils = new MdsalUtils(dataBroker);
        this.southboundUtils = new SouthboundUtils(this.mdsalUtils);
    }

    public NodeInfo createNodeInfo(ConnectionInfo connectionInfo, List<NotifyingDataChangeListener> waitList) {
        return new NodeInfo(connectionInfo, this, waitList);
    }

    public boolean isControllerConnected(ConnectionInfo connectionInfo) throws InterruptedException {
        LOG.info("isControllerConnected enter");
        Node ovsdbNode = this.southboundUtils.getOvsdbNode(connectionInfo);
        Assert.assertNotNull((String)"ovsdb node not found", (Object)ovsdbNode);
        String controllerTarget = (String)this.southboundUtils.getControllersFromOvsdbNode(ovsdbNode).get(0);
        Assert.assertNotNull((String)"Failed to get controller target", (Object)controllerTarget);
        for (int i = 0; i < 10; ++i) {
            LOG.info("isControllerConnected try {}: looking for controller: {}", (Object)i, (Object)controllerTarget);
            OvsdbBridgeAugmentation bridge = this.southboundUtils.getBridge(connectionInfo, "br-int");
            if (bridge != null && bridge.getControllerEntry() != null) {
                ControllerEntry controllerEntry = (ControllerEntry)bridge.getControllerEntry().values().iterator().next();
                Assert.assertEquals((Object)controllerTarget, (Object)controllerEntry.getTarget().getValue());
                if (controllerEntry.getIsConnected().booleanValue()) {
                    LOG.info("isControllerConnected exit: true {}", (Object)controllerTarget);
                    return true;
                }
            }
            Thread.sleep(1000L);
        }
        LOG.info("isControllerConnected exit: false {}", (Object)controllerTarget);
        return false;
    }
}

