/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.utils.ovsdb.it.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ProcUtils.class);

    private ProcUtils() {
    }

    public static void runProcess(long waitFor, String ... words) throws IOException, InterruptedException {
        ProcUtils.runProcess(waitFor, null, words);
    }

    public static void runProcess(long waitFor, StringBuilder capturedStdout, String ... words) throws IOException, InterruptedException {
        int exitValue = ProcUtils.tryProcess(null, waitFor, capturedStdout, words);
        Assert.assertEquals((String)"ProcUtils.runProcess exit code is not 0", (long)0L, (long)exitValue);
    }

    public static int runProcess(int reserved, long waitFor, StringBuilder capturedStdout, String ... words) throws IOException, InterruptedException {
        int exitValue = ProcUtils.tryProcess(null, waitFor, capturedStdout, words);
        LOG.info("ProcUtils.runProcess exit code: {}", (Object)exitValue);
        return exitValue;
    }

    public static int tryProcess(String logText, long waitFor, String ... words) throws IOException, InterruptedException {
        return ProcUtils.tryProcess(logText, waitFor, null, words);
    }

    public static int tryProcess(String logText, long waitFor, StringBuilder capturedStdout, String ... words) throws IOException, InterruptedException {
        LOG.info("ProcUtils.runProcess {} running \"{}\", waitFor {}", new Object[]{logText != null ? logText : "", words, waitFor});
        Process proc = new ProcessBuilder(words).start();
        int exitValue = -1;
        try (BufferedReader stdout = new BufferedReader(new InputStreamReader(proc.getInputStream(), StandardCharsets.UTF_8));
             BufferedReader stderr = new BufferedReader(new InputStreamReader(proc.getErrorStream(), StandardCharsets.UTF_8));){
            int read;
            exitValue = ProcUtils.waitForExitValue(waitFor, proc);
            while (stderr.ready()) {
                LOG.warn("ProcUtils.runProcess {} [stderr]: {}", (Object)(logText != null ? logText : ""), (Object)stderr.readLine());
            }
            StringBuilder stdoutStringBuilder = capturedStdout != null ? capturedStdout : new StringBuilder();
            char[] buf = new char[1024];
            while (-1 != (read = stdout.read(buf))) {
                stdoutStringBuilder.append(buf, 0, read);
            }
            LOG.info("ProcUtils.runProcess {} [stdout]:\n{}", (Object)(logText != null ? logText : ""), (Object)stdoutStringBuilder.toString());
        }
        return exitValue;
    }

    private static int waitForExitValue(long waitFor, Process proc) throws InterruptedException {
        int exitValue = -1;
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                exitValue = proc.exitValue();
            }
            catch (IllegalThreadStateException e) {
                if (System.currentTimeMillis() - startTime < waitFor) {
                    Thread.sleep(200L);
                    continue;
                }
                LOG.warn("ProcUtils.waitForExitValue: timed out while waiting for command to complete", (Throwable)e);
            }
            break;
        }
        return exitValue;
    }
}

