/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.utils.ovsdb.it.utils;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.YamlReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.opendaylight.ovsdb.utils.ovsdb.it.utils.ProcUtils;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerOvs
implements AutoCloseable {
    private static String ENV_USAGE = "Usage:\n-Ddocker.run - explicitly configure whether or not DockerOvs should run docker-compose\n-Dovsdbserver.ipaddress - specify IP address of ovsdb server - implies -Ddocker.run=false\n-Dovsdbserver.port - specify the port of the ovsdb server - required with -Dovsdbserver.ipaddress\n-Ddocker.compose.file - docker compose file in META-INF/docker-compose-files/. If not specified, default file is used\n-Dovsdb.userspace.enabled - true when Ovs is running in user space (usually the case with docker)\n-Dovsdb.controller.address - IP address of the controller (usually the docker0 interface with docker)\nTo auto-run Ovs and connect actively:\n -Dovsdb.controller.address=x.x.x.x -Dovsdb.userspace.enabled=yes <-Ddocker.compose.file=ffff>\nTo auto-run Ovs and connect passively:\n -Dovsdbserver.connection=passive -Dovsdb.controller.address=x.x.x.x -Dovsdb.userspace.enabled=yes <-Ddocker.compose.file=ffff>\nTo actively connect to a running Ovs:\n -Dovsdbserver.ipaddress=x.x.x.x -Dovsdbserver.port=6641 -Dovsdb.controller.address=y.y.y.y\nTo passively connect to a running Ovs:\n -Dovsdbserver.connection=passive -Ddocker.run=false\n";
    private static final Logger LOG = LoggerFactory.getLogger(DockerOvs.class);
    private static final String DEFAULT_DOCKER_FILE = "ovs-2.5.0-hwvtep.yml";
    private static final String DOCKER_FILE_PATH = "META-INF/docker-compose-files/";
    private static final int COMPOSE_FILE_IDX = 3;
    private static final int COMPOSE_FILE_IDX_NO_SUDO = 2;
    private static final String DEFAULT_OVSDB_HOST = "127.0.0.1";
    private static final String ODL_NET_GATEWAY = "172.99.0.254";
    private String[] psCmd = new String[]{"sudo", "docker-compose", "-f", null, "ps"};
    private String[] psCmdNoSudo = new String[]{"docker-compose", "-f", null, "ps"};
    private String[] upCmd = new String[]{"sudo", "docker-compose", "-f", null, "up", "-d", "--force-recreate"};
    private String[] downCmd = new String[]{"sudo", "docker-compose", "-f", null, "stop"};
    private String[] execCmd = new String[]{"sudo", "docker-compose", "-f", null, "exec", null};
    private String[] dockerPsCmdNoSudo = new String[]{"docker", "ps"};
    private String[] dockerPsCmd = new String[]{"sudo", "docker", "ps"};
    private String[] netInspectCmd = new String[]{"sudo", "docker", "network", "inspect", "odl"};
    private String[] netCreateCmd = new String[]{"sudo", "docker", "network", "create", "--subnet=172.99.0.0/16", "--gateway=172.99.0.254", "odl"};
    private File tmpDockerComposeFile;
    boolean isRunning;
    private String envServerAddress;
    private String envServerPort;
    private String envDockerComposeFile;
    private String envDockerWaitForPing;
    private boolean runDocker;
    private boolean runVenv;
    private boolean createOdlNetwork;
    private Map<String, DockerComposeServiceInfo> dockerComposeServices = new HashMap<String, DockerComposeServiceInfo>();

    public static Option[] getSysPropOptions() {
        return new Option[]{CoreOptions.propagateSystemProperties((String[])new String[]{"ovsdbserver.ipaddress", "ovsdbserver.port", "ovsdbserver.connection", "ovsdb.controller.address", "ovsdb.userspace.enabled", "docker.compose.file", "docker.run", "docker.ping.wait.secs", "docker.vEnvWs"})};
    }

    public DockerOvs() throws IOException, InterruptedException {
        this(DEFAULT_DOCKER_FILE);
    }

    public DockerOvs(String yamlFileName) throws IOException, InterruptedException {
        this.configureFromEnv();
        if (!this.runDocker) {
            LOG.info("DockerOvs.DockerOvs: Not running docker, -D{} specified", (Object)"ovsdbserver.ipaddress");
            return;
        }
        this.tmpDockerComposeFile = this.createTempDockerComposeFile(yamlFileName);
        this.buildDockerCommands();
        this.parseDockerComposeYaml();
        this.isRunning = false;
        this.networkUp();
        ProcUtils.runProcess(60000L, this.upCmd);
        this.isRunning = true;
        int waitSeconds = Integer.parseInt(this.envDockerWaitForPing);
        this.waitForOvsdbServers(waitSeconds * 1000);
    }

    private void setupEnvForDockerCompose(String venvWs) {
        String dockerCompose = venvWs + "/venv/bin/docker-compose";
        String[] psCmdVenv = new String[]{"sudo", dockerCompose, "-f", null, "ps"};
        String[] psCmdNoSudoVenv = new String[]{dockerCompose, "-f", null, "ps"};
        String[] upCmdVenv = new String[]{"sudo", dockerCompose, "-f", null, "up", "-d", "--force-recreate"};
        String[] downCmdVenv = new String[]{"sudo", dockerCompose, "-f", null, "stop"};
        String[] execCmdVenv = new String[]{"sudo", dockerCompose, "-f", null, "exec", null};
        this.psCmd = psCmdVenv;
        this.psCmdNoSudo = psCmdNoSudoVenv;
        this.upCmd = upCmdVenv;
        this.downCmd = downCmdVenv;
        this.execCmd = execCmdVenv;
    }

    private void configureFromEnv() {
        Properties env = System.getProperties();
        this.envServerAddress = env.getProperty("ovsdbserver.ipaddress");
        this.envServerPort = env.getProperty("ovsdbserver.port");
        this.envDockerWaitForPing = env.getProperty("docker.ping.wait.secs", "10");
        this.createOdlNetwork = env.getProperty("ovsdb.controller.address") == null;
        String envRunDocker = env.getProperty("docker.run");
        String connType = env.getProperty("ovsdbserver.connection", "active");
        String dockerFile = env.getProperty("docker.compose.file");
        String venvWs = env.getProperty("docker.vEnvWs");
        this.envDockerComposeFile = DOCKER_FILE_PATH + (null == dockerFile ? DEFAULT_DOCKER_FILE : dockerFile);
        boolean bl = envRunDocker != null ? Boolean.parseBoolean(envRunDocker) : (this.runDocker = this.envServerAddress == null);
        if (venvWs != null && !venvWs.isEmpty()) {
            LOG.info("Setting up virtual environment for docker compose");
            this.setupEnvForDockerCompose(venvWs);
        }
        if (this.runDocker) {
            return;
        }
        if (connType.equals("passive")) {
            return;
        }
        Assert.assertNotNull((String)("Attempt to connect to previous running ovs but missing -Dovsdbserver.ipaddress\n" + ENV_USAGE), (Object)this.envServerAddress);
        Assert.assertNotNull((String)("Attempt to connect to previous running ovs but missing -Dovsdbserver.port\n" + ENV_USAGE), (Object)this.envServerPort);
    }

    private void buildDockerCommands() throws IOException, InterruptedException {
        this.psCmd[3] = this.tmpDockerComposeFile.toString();
        this.psCmdNoSudo[2] = this.tmpDockerComposeFile.toString();
        this.upCmd[3] = this.tmpDockerComposeFile.toString();
        this.downCmd[3] = this.tmpDockerComposeFile.toString();
        this.execCmd[3] = this.tmpDockerComposeFile.toString();
        if (0 == ProcUtils.tryProcess(null, 5000L, this.psCmdNoSudo)) {
            LOG.info("DockerOvs.buildDockerCommands docker-compose does not require sudo");
            this.upCmd = this.removeFirstEl(this.upCmd);
            this.downCmd = this.removeFirstEl(this.downCmd);
            this.execCmd = this.removeFirstEl(this.execCmd);
        } else if (0 == ProcUtils.tryProcess(null, 5000L, this.psCmd)) {
            LOG.info("DockerOvs.buildDockerCommands docker-compose requires sudo");
        } else {
            Assert.fail((String)"docker-compose does not seem to work with or without sudo");
        }
        if (0 == ProcUtils.tryProcess(null, 5000L, this.dockerPsCmdNoSudo)) {
            LOG.info("DockerOvs.buildDockerCommands docker does not require sudo");
            this.netCreateCmd = this.removeFirstEl(this.netCreateCmd);
            this.netInspectCmd = this.removeFirstEl(this.netInspectCmd);
        } else if (0 == ProcUtils.tryProcess(null, 5000L, this.dockerPsCmd)) {
            LOG.info("DockerOvs.buildDockerCommands docker requires sudo");
        } else {
            Assert.fail((String)"docker does not seem to work with or without sudo");
        }
    }

    private String[] removeFirstEl(String[] arr) {
        return Arrays.copyOfRange(arr, 1, arr.length);
    }

    private void networkUp() throws IOException, InterruptedException {
        if (this.usingExternalDocker() || !this.createOdlNetwork) {
            return;
        }
        if (0 != ProcUtils.tryProcess(null, 5000L, this.netInspectCmd)) {
            ProcUtils.runProcess(5000L, this.netCreateCmd);
        }
        System.getProperties().setProperty("ovsdb.controller.address", ODL_NET_GATEWAY);
    }

    public boolean usingExternalDocker() {
        return !this.runDocker;
    }

    public String getOvsdbAddress(int ovsNumber) {
        if (!this.runDocker) {
            return this.envServerAddress;
        }
        return DEFAULT_OVSDB_HOST;
    }

    public String getOvsdbPort(int ovsNumber) {
        if (!this.runDocker) {
            return this.envServerPort;
        }
        return this.dockerComposeServices.get((Object)this.getOvsNumString((int)ovsNumber)).port;
    }

    public String getOvsdbPort(String ovsName) {
        if (!this.runDocker) {
            return this.envServerPort;
        }
        return this.dockerComposeServices.get((Object)ovsName).port;
    }

    public int getNumOvsNodes() {
        return this.dockerComposeServices.size();
    }

    private String getOvsNumString(int numOvs) {
        if (numOvs == 0) {
            return "ovs1";
        }
        return "ovs" + numOvs;
    }

    public String[] getExecCmdPrefix(int numOvs) {
        String[] res = new String[this.execCmd.length];
        System.arraycopy(this.execCmd, 0, res, 0, this.execCmd.length);
        res[res.length - 1] = this.dockerComposeServices.get((Object)this.getOvsNumString((int)numOvs)).name;
        return res;
    }

    public void runInContainer(int waitFor, int numOvs, String ... cmdWords) throws IOException, InterruptedException {
        String[] pfx = this.getExecCmdPrefix(numOvs);
        String[] cmd = new String[pfx.length + cmdWords.length];
        System.arraycopy(pfx, 0, cmd, 0, pfx.length);
        System.arraycopy(cmdWords, 0, cmd, pfx.length, cmdWords.length);
        ProcUtils.runProcess((long)waitFor, cmd);
    }

    public int runInContainer(int reserved, int waitFor, int numOvs, String ... cmdWords) throws IOException, InterruptedException {
        String[] pfx = this.getExecCmdPrefix(numOvs);
        String[] cmd = new String[pfx.length + cmdWords.length];
        System.arraycopy(pfx, 0, cmd, 0, pfx.length);
        System.arraycopy(cmdWords, 0, cmd, pfx.length, cmdWords.length);
        return ProcUtils.runProcess(reserved, waitFor, null, cmd);
    }

    public int runInContainer(int reserved, int waitFor, StringBuilder capturedStdout, int numOvs, String ... cmdWords) throws IOException, InterruptedException {
        String[] pfx = this.getExecCmdPrefix(numOvs);
        String[] cmd = new String[pfx.length + cmdWords.length];
        System.arraycopy(pfx, 0, cmd, 0, pfx.length);
        System.arraycopy(cmdWords, 0, cmd, pfx.length, cmdWords.length);
        return ProcUtils.runProcess(reserved, waitFor, capturedStdout, cmd);
    }

    public void tryInContainer(String logText, int waitFor, int numOvs, String ... cmdWords) throws IOException, InterruptedException {
        String[] pfx = this.getExecCmdPrefix(numOvs);
        String[] cmd = new String[pfx.length + cmdWords.length];
        System.arraycopy(pfx, 0, cmd, 0, pfx.length);
        System.arraycopy(cmdWords, 0, cmd, pfx.length, cmdWords.length);
        ProcUtils.tryProcess(logText, (long)waitFor, cmd);
    }

    private List<String> parseDockerComposeYaml() {
        ArrayList<String> ports = new ArrayList<String>();
        YamlReader yamlReader = null;
        Map root = null;
        try {
            yamlReader = new YamlReader((Reader)new FileReader(this.tmpDockerComposeFile));
            root = (Map)yamlReader.read();
        }
        catch (FileNotFoundException e) {
            LOG.warn("DockerOvs.parseDockerComposeYaml error reading yaml file", (Throwable)e);
            return ports;
        }
        catch (YamlException e) {
            LOG.warn("DockerOvs.parseDockerComposeYaml error parsing yaml file", (Throwable)e);
            return ports;
        }
        if (null == root) {
            return ports;
        }
        String composeVersion = (String)root.get("version");
        if (null != composeVersion && composeVersion.equals("2")) {
            root = (Map)root.get("services");
        }
        for (Map.Entry entry : root.entrySet()) {
            String key = (String)entry.getKey();
            Map map = (Map)entry.getValue();
            DockerComposeServiceInfo svc = new DockerComposeServiceInfo();
            svc.name = key;
            List portMappings = (List)map.get("ports");
            if (null == portMappings) continue;
            for (Object portMapping : portMappings) {
                String portMappingStr = (String)portMapping;
                int delim = portMappingStr.indexOf(":");
                if (delim == -1) continue;
                String port = portMappingStr.substring(0, delim);
                ports.add(port);
                svc.port = port;
            }
            this.dockerComposeServices.put(svc.name, svc);
        }
        return ports;
    }

    @Override
    public void close() throws Exception {
        if (this.isRunning) {
            ProcUtils.runProcess(10000L, this.downCmd);
            this.isRunning = false;
        }
        try {
            this.tmpDockerComposeFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void waitForOvsdbServers(long waitFor) throws IOException, InterruptedException {
        AtomicInteger numRunningOvs = new AtomicInteger(0);
        int numOvs = this.dockerComposeServices.size();
        if (0 == numOvs) {
            return;
        }
        OvsdbPing[] pingers = new OvsdbPing[numOvs];
        if (numOvs == 1) {
            pingers[0] = new OvsdbPing(0, numRunningOvs);
            pingers[0].start();
        } else {
            for (int i = 0; i < numOvs; ++i) {
                pingers[i] = new OvsdbPing(i + 1, numRunningOvs);
                pingers[i].start();
            }
        }
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < waitFor) {
            if (numRunningOvs.get() >= numOvs) {
                LOG.info("DockerOvs.waitForOvsdbServers all OVS instances running");
                break;
            }
            Thread.sleep(1000L);
        }
        LOG.info("DockerOvs.waitForOvsdbServers - finished waiting in {}", (Object)(System.currentTimeMillis() - startTime));
        for (OvsdbPing pinger : pingers) {
            pinger.interrupt();
        }
    }

    private File createTempDockerComposeFile(String yamlFileName) {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        Assert.assertNotNull((String)"DockerOvs: bundle is null", (Object)bundle);
        URL url = bundle.getResource(this.envDockerComposeFile);
        Assert.assertNotNull((String)"DockerOvs: URL is null", (Object)url);
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("ovsdb-it-tmp-", null);
            try (InputStreamReader in = new InputStreamReader(url.openStream());
                 FileWriter out = new FileWriter(tmpFile);){
                int read;
                char[] buf = new char[1024];
                while (-1 != (read = in.read(buf))) {
                    out.write(buf, 0, read);
                }
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.toString());
        }
        return tmpFile;
    }

    public void logState(int dockerInstance, String logText) throws IOException, InterruptedException {
        this.tryInContainer(logText, 5000, dockerInstance, "ip", "addr");
        this.tryInContainer(logText, 5000, dockerInstance, "ovs-vsctl", "show");
        this.tryInContainer(logText, 5000, dockerInstance, "ovs-ofctl", "-OOpenFlow13", "show", "br-int");
        this.tryInContainer(logText, 5000, dockerInstance, "ovs-ofctl", "-OOpenFlow13", "dump-flows", "br-int");
        this.tryInContainer(logText, 5000, dockerInstance, "ip", "netns", "list");
    }

    class OvsdbPing
    extends Thread {
        private final String host;
        private final int port;
        private final AtomicInteger result;
        public CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
        ByteBuffer listDbsRequest;

        public OvsdbPing(int ovsNumber, AtomicInteger result) {
            this.host = DockerOvs.this.getOvsdbAddress(ovsNumber);
            this.port = Integer.parseInt(DockerOvs.this.getOvsdbPort(ovsNumber));
            this.result = result;
            this.listDbsRequest = ByteBuffer.wrap(("{\"method\": \"list_dbs\", \"params\": [], \"id\": " + this.port + "}").getBytes());
            this.listDbsRequest.mark();
        }

        @Override
        public void run() {
            while (!this.doPing()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LOG.warn("OvsdbPing interrupted", (Throwable)e);
                    return;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean doPing() {
            try (SocketChannel socketChannel = SocketChannel.open(new InetSocketAddress(this.host, this.port));){
                socketChannel.write(this.listDbsRequest);
                this.listDbsRequest.reset();
                ByteBuffer buf = ByteBuffer.allocateDirect(512);
                socketChannel.read(buf);
                buf.flip();
                String response = this.decoder.decode(buf).toString();
                if (!response.contains("Open_vSwitch")) return false;
                LOG.info("OvsdbPing connection validated");
                this.result.incrementAndGet();
                boolean bl = true;
                return bl;
            }
            catch (ClosedByInterruptException e) {
                LOG.warn("OvsdbPing interrupted", (Throwable)e);
                return true;
            }
            catch (Exception e) {
                LOG.info("OvsdbPing exception while attempting connect {}", (Object)e.toString());
            }
            return false;
        }
    }

    class DockerComposeServiceInfo {
        public String name;
        public String port;

        DockerComposeServiceInfo() {
        }
    }
}

