/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.utils.ovsdb.it.utils;

import java.util.List;
import org.junit.Assert;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.ovsdb.utils.mdsal.utils.ControllerNotifyingDataChangeListener;
import org.opendaylight.ovsdb.utils.ovsdb.it.utils.OvsdbItUtils;
import org.opendaylight.ovsdb.utils.southbound.utils.SouthboundUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.ovsdb.node.attributes.ConnectionInfo;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeInfo {
    private static final Logger LOG = LoggerFactory.getLogger(NodeInfo.class);
    public static final String INTEGRATION_BRIDGE_NAME = "br-int";
    private final ConnectionInfo connectionInfo;
    private final InstanceIdentifier<Node> ovsdbIid;
    private final InstanceIdentifier<Node> bridgeIid;
    public long datapathId;
    public Node ovsdbNode;
    public Node bridgeNode;
    private ControllerNotifyingDataChangeListener ovsdbWaiter;
    private ControllerNotifyingDataChangeListener bridgeWaiter;
    private final List<ControllerNotifyingDataChangeListener> waitList;
    private final OvsdbItUtils itUtils;

    NodeInfo(ConnectionInfo connectionInfo, OvsdbItUtils itUtils, List<ControllerNotifyingDataChangeListener> waitList) {
        this.connectionInfo = connectionInfo;
        this.itUtils = itUtils;
        this.waitList = waitList;
        this.ovsdbIid = SouthboundUtils.createInstanceIdentifier((ConnectionInfo)connectionInfo);
        this.bridgeIid = SouthboundUtils.createInstanceIdentifier((ConnectionInfo)connectionInfo, (String)INTEGRATION_BRIDGE_NAME);
    }

    private void addWaiters() {
        this.ovsdbWaiter = new ControllerNotifyingDataChangeListener(LogicalDatastoreType.OPERATIONAL, 1, this.ovsdbIid, this.waitList);
        this.ovsdbWaiter.registerDataChangeListener(this.itUtils.dataBroker);
        this.bridgeWaiter = new ControllerNotifyingDataChangeListener(LogicalDatastoreType.OPERATIONAL, 1, this.bridgeIid, this.waitList);
        this.bridgeWaiter.registerDataChangeListener(this.itUtils.dataBroker);
    }

    private void closeWaiters() throws Exception {
        this.ovsdbWaiter.close();
        this.bridgeWaiter.close();
    }

    public void connect() throws Exception {
        this.addWaiters();
        Assert.assertNotNull((String)"connection failed", (Object)this.itUtils.southboundUtils.addOvsdbNode(this.connectionInfo, 0L));
        this.ovsdbWaiter.waitForCreation();
        this.ovsdbNode = this.itUtils.southboundUtils.getOvsdbNode(this.connectionInfo);
        Assert.assertNotNull((String)"node is not connected", (Object)this.ovsdbNode);
        this.bridgeWaiter.waitForCreation();
        Assert.assertTrue((String)("Controller " + SouthboundUtils.connectionInfoToString((ConnectionInfo)this.connectionInfo) + " is not connected"), (boolean)this.itUtils.isControllerConnected(this.connectionInfo));
        this.bridgeNode = this.itUtils.southboundUtils.getBridgeNode(this.ovsdbNode, INTEGRATION_BRIDGE_NAME);
        Assert.assertNotNull((String)"bridge br-int was not found", (Object)this.bridgeNode);
        this.datapathId = this.itUtils.southboundUtils.getDataPathId(this.bridgeNode);
        String datapathIdString = this.itUtils.southboundUtils.getDatapathId(this.bridgeNode);
        LOG.info("NodeInfo.connect: bridgeNode: {}, datapathId: {} - {}", new Object[]{this.bridgeNode, datapathIdString, this.datapathId});
        Assert.assertNotEquals((String)"datapathId was not found", (long)this.datapathId, (long)0L);
    }

    public void disconnect() throws Exception {
        this.ovsdbWaiter.setMask(4);
        this.bridgeWaiter.setMask(4);
        Assert.assertTrue((boolean)this.itUtils.southboundUtils.deleteBridge(this.connectionInfo, INTEGRATION_BRIDGE_NAME, 0L));
        this.bridgeWaiter.waitForDeletion();
        Assert.assertNull((String)"Bridge should not be found", (Object)this.itUtils.mdsalUtils.read(LogicalDatastoreType.OPERATIONAL, this.bridgeIid));
        Assert.assertTrue((boolean)this.itUtils.southboundUtils.disconnectOvsdbNode(this.connectionInfo, 0L));
        this.ovsdbWaiter.waitForDeletion();
        Assert.assertNull((String)"Ovsdb node should not be found", (Object)this.itUtils.mdsalUtils.read(LogicalDatastoreType.OPERATIONAL, this.ovsdbIid));
        this.closeWaiters();
    }
}

