/*
 * Decompiled with CFR 0.152.
 */
package com.google.instrumentation.trace;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.instrumentation.trace.SpanContext;
import com.google.instrumentation.trace.SpanId;
import com.google.instrumentation.trace.TraceId;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Link {
    private final TraceId traceId;
    private final SpanId spanId;
    private final Type type;

    public static Link fromSpanContext(SpanContext context, Type type) {
        return new Link(context.getTraceId(), context.getSpanId(), type);
    }

    public TraceId getTraceId() {
        return this.traceId;
    }

    public SpanId getSpanId() {
        return this.spanId;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Link)) {
            return false;
        }
        Link that = (Link)obj;
        return Objects.equal((Object)this.traceId, (Object)that.traceId) && Objects.equal((Object)this.spanId, (Object)that.spanId) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.traceId, this.spanId, this.type});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("traceId", (Object)this.traceId).add("spanId", (Object)this.spanId).add("type", (Object)this.type).toString();
    }

    private Link(TraceId traceId, SpanId spanId, Type type) {
        this.traceId = traceId;
        this.spanId = spanId;
        this.type = type;
    }

    public static enum Type {
        CHILD,
        PARENT;

    }
}

