/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Attributes {
    private final Map<Key<?>, Object> data;
    public static final Attributes EMPTY = new Attributes(Collections.<Key<?>, Object>emptyMap());

    private Attributes(Map<Key<?>, Object> data) {
        assert (data != null);
        this.data = data;
    }

    @Nullable
    public <T> T get(Key<T> key) {
        return (T)this.data.get(key);
    }

    public Set<Key<?>> keys() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    public static Builder newBuilder(Attributes base) {
        Preconditions.checkNotNull((Object)base, (Object)"base");
        return new Builder(base);
    }

    public static Builder newBuilder() {
        return new Builder(EMPTY);
    }

    public String toString() {
        return this.data.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attributes that = (Attributes)o;
        return Objects.equal(this.data, that.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public static final class Builder {
        private Attributes base;
        private Map<Key<?>, Object> newdata;

        private Builder(Attributes base) {
            assert (base != null);
            this.base = base;
        }

        private Map<Key<?>, Object> data(int size) {
            if (this.newdata == null) {
                this.newdata = new IdentityHashMap(size);
            }
            return this.newdata;
        }

        public <T> Builder set(Key<T> key, T value) {
            this.data(1).put(key, value);
            return this;
        }

        public <T> Builder setAll(Attributes other) {
            this.data(other.data.size()).putAll(other.data);
            return this;
        }

        public Attributes build() {
            if (this.newdata != null) {
                for (Map.Entry entry : this.base.data.entrySet()) {
                    if (this.newdata.containsKey(entry.getKey())) continue;
                    this.newdata.put((Key<?>)entry.getKey(), entry.getValue());
                }
                this.base = new Attributes(this.newdata);
                this.newdata = null;
            }
            return this.base;
        }
    }

    @Immutable
    public static final class Key<T> {
        private final String name;

        private Key(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static <T> Key<T> of(String name) {
            return new Key<T>(name);
        }
    }
}

