/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.base.Preconditions;
import io.grpc.internal.SerializingExecutor;
import io.grpc.okhttp.OkHttpClientTransport;
import io.grpc.okhttp.internal.framed.ErrorCode;
import io.grpc.okhttp.internal.framed.FrameWriter;
import io.grpc.okhttp.internal.framed.Header;
import io.grpc.okhttp.internal.framed.Settings;
import java.io.IOException;
import java.net.Socket;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import okio.Buffer;

class AsyncFrameWriter
implements FrameWriter {
    private static final Logger log = Logger.getLogger(OkHttpClientTransport.class.getName());
    private FrameWriter frameWriter;
    private Socket socket;
    private final SerializingExecutor executor;
    private final OkHttpClientTransport transport;

    public AsyncFrameWriter(OkHttpClientTransport transport, SerializingExecutor executor) {
        this.transport = transport;
        this.executor = executor;
    }

    void becomeConnected(FrameWriter frameWriter, Socket socket) {
        Preconditions.checkState((this.frameWriter == null ? 1 : 0) != 0, (Object)"AsyncFrameWriter's setFrameWriter() should only be called once.");
        this.frameWriter = (FrameWriter)Preconditions.checkNotNull((Object)frameWriter, (Object)"frameWriter");
        this.socket = (Socket)Preconditions.checkNotNull((Object)socket, (Object)"socket");
    }

    @Override
    public void connectionPreface() {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.connectionPreface();
            }
        });
    }

    @Override
    public void ackSettings(final Settings peerSettings) {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.ackSettings(peerSettings);
            }
        });
    }

    @Override
    public void pushPromise(final int streamId, final int promisedStreamId, final List<Header> requestHeaders) {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.pushPromise(streamId, promisedStreamId, requestHeaders);
            }
        });
    }

    @Override
    public void flush() {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.flush();
            }
        });
    }

    @Override
    public void synStream(final boolean outFinished, final boolean inFinished, final int streamId, final int associatedStreamId, final List<Header> headerBlock) {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.synStream(outFinished, inFinished, streamId, associatedStreamId, headerBlock);
            }
        });
    }

    @Override
    public void synReply(final boolean outFinished, final int streamId, final List<Header> headerBlock) {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.synReply(outFinished, streamId, headerBlock);
            }
        });
    }

    @Override
    public void headers(final int streamId, final List<Header> headerBlock) {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.headers(streamId, headerBlock);
            }
        });
    }

    @Override
    public void rstStream(final int streamId, final ErrorCode errorCode) {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.rstStream(streamId, errorCode);
            }
        });
    }

    @Override
    public void data(final boolean outFinished, final int streamId, final Buffer source, final int byteCount) {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.data(outFinished, streamId, source, byteCount);
            }
        });
    }

    @Override
    public void settings(final Settings okHttpSettings) {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.settings(okHttpSettings);
            }
        });
    }

    @Override
    public void ping(final boolean ack, final int payload1, final int payload2) {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.ping(ack, payload1, payload2);
            }
        });
    }

    @Override
    public void goAway(final int lastGoodStreamId, final ErrorCode errorCode, final byte[] debugData) {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.goAway(lastGoodStreamId, errorCode, debugData);
                AsyncFrameWriter.this.frameWriter.flush();
            }
        });
    }

    @Override
    public void windowUpdate(final int streamId, final long windowSizeIncrement) {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.windowUpdate(streamId, windowSizeIncrement);
            }
        });
    }

    @Override
    public void close() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (AsyncFrameWriter.this.frameWriter != null) {
                    try {
                        AsyncFrameWriter.this.frameWriter.close();
                        AsyncFrameWriter.this.socket.close();
                    }
                    catch (IOException e) {
                        log.log(Level.WARNING, "Failed closing connection", e);
                    }
                }
            }
        });
    }

    @Override
    public int maxDataLength() {
        return this.frameWriter == null ? 16384 : this.frameWriter.maxDataLength();
    }

    private abstract class WriteRunnable
    implements Runnable {
        private WriteRunnable() {
        }

        @Override
        public final void run() {
            try {
                if (AsyncFrameWriter.this.frameWriter == null) {
                    throw new IOException("Unable to perform write due to unavailable frameWriter.");
                }
                this.doRun();
            }
            catch (RuntimeException e) {
                AsyncFrameWriter.this.transport.onException(e);
            }
            catch (Exception e) {
                AsyncFrameWriter.this.transport.onException(e);
            }
        }

        public abstract void doRun() throws IOException;
    }
}

