/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.protobuf.nano;

import com.google.common.base.Preconditions;
import com.google.protobuf.nano.CodedInputByteBufferNano;
import com.google.protobuf.nano.MessageNano;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.nano.MessageNanoFactory;
import io.grpc.protobuf.nano.NanoProtoInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NanoUtils {
    private static final int BUF_SIZE = 8192;

    private NanoUtils() {
    }

    public static <T extends MessageNano> MethodDescriptor.Marshaller<T> marshaller(final MessageNanoFactory<T> factory) {
        return new MethodDescriptor.Marshaller<T>(){

            @Override
            public InputStream stream(T value) {
                return new NanoProtoInputStream((MessageNano)value);
            }

            @Override
            public T parse(InputStream stream) {
                try {
                    CodedInputByteBufferNano input = CodedInputByteBufferNano.newInstance(NanoUtils.toByteArray(stream));
                    input.setSizeLimit(Integer.MAX_VALUE);
                    Object message = factory.newInstance();
                    ((MessageNano)message).mergeFrom(input);
                    return message;
                }
                catch (IOException ipbe) {
                    throw Status.INTERNAL.withDescription("Failed parsing nano proto message").withCause(ipbe).asRuntimeException();
                }
            }
        };
    }

    private static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        NanoUtils.copy(in, out);
        return out.toByteArray();
    }

    private static long copy(InputStream from, OutputStream to) throws IOException {
        int r;
        Preconditions.checkNotNull((Object)from);
        Preconditions.checkNotNull((Object)to);
        byte[] buf = new byte[8192];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }
}

