/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.stats;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.opencensus.common.Functions;
import io.opencensus.common.Timestamp;
import io.opencensus.stats.Measure;
import io.opencensus.stats.MeasureMap;
import io.opencensus.stats.StatsCollectionState;
import io.opencensus.stats.StatsComponent;
import io.opencensus.stats.StatsRecorder;
import io.opencensus.stats.View;
import io.opencensus.stats.ViewData;
import io.opencensus.stats.ViewManager;
import io.opencensus.tags.TagContext;
import java.util.Collections;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

final class NoopStats {
    private NoopStats() {
    }

    static StatsComponent newNoopStatsComponent() {
        return new NoopStatsComponent();
    }

    static StatsRecorder getNoopStatsRecorder() {
        return NoopStatsRecorder.INSTANCE;
    }

    static MeasureMap getNoopMeasureMap() {
        return NoopMeasureMap.INSTANCE;
    }

    static ViewManager newNoopViewManager() {
        return new NoopViewManager();
    }

    @ThreadSafe
    private static final class NoopViewManager
    extends ViewManager {
        private static final Timestamp ZERO_TIMESTAMP = Timestamp.create(0L, 0);
        @GuardedBy(value="views")
        private final Map<View.Name, View> views = Maps.newHashMap();

        private NoopViewManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerView(View newView) {
            Preconditions.checkNotNull((Object)newView, (Object)"newView");
            Map<View.Name, View> map = this.views;
            synchronized (map) {
                View existing = this.views.get(newView.getName());
                Preconditions.checkArgument((existing == null || newView.equals(existing) ? 1 : 0) != 0, (Object)"A different view with the same name already exists.");
                if (existing == null) {
                    this.views.put(newView.getName(), newView);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ViewData getView(View.Name name) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            Map<View.Name, View> map = this.views;
            synchronized (map) {
                View view = this.views.get(name);
                if (view == null) {
                    return null;
                }
                return ViewData.create(view, Collections.emptyMap(), view.getWindow().match(Functions.returnConstant(ViewData.AggregationWindowData.CumulativeData.create(ZERO_TIMESTAMP, ZERO_TIMESTAMP)), Functions.returnConstant(ViewData.AggregationWindowData.IntervalData.create(ZERO_TIMESTAMP)), Functions.throwAssertionError()));
            }
        }
    }

    @Immutable
    private static final class NoopMeasureMap
    extends MeasureMap {
        static final MeasureMap INSTANCE = new NoopMeasureMap();

        private NoopMeasureMap() {
        }

        @Override
        public MeasureMap put(Measure.MeasureDouble measure, double value) {
            return this;
        }

        @Override
        public MeasureMap put(Measure.MeasureLong measure, long value) {
            return this;
        }

        @Override
        public void record() {
        }

        @Override
        public void record(TagContext tags) {
            Preconditions.checkNotNull((Object)tags, (Object)"tags");
        }
    }

    @Immutable
    private static final class NoopStatsRecorder
    extends StatsRecorder {
        static final StatsRecorder INSTANCE = new NoopStatsRecorder();

        private NoopStatsRecorder() {
        }

        @Override
        public MeasureMap newMeasureMap() {
            return NoopStats.getNoopMeasureMap();
        }
    }

    @ThreadSafe
    private static final class NoopStatsComponent
    extends StatsComponent {
        private final ViewManager viewManager = NoopStats.newNoopViewManager();

        private NoopStatsComponent() {
        }

        @Override
        public ViewManager getViewManager() {
            return this.viewManager;
        }

        @Override
        public StatsRecorder getStatsRecorder() {
            return NoopStats.getNoopStatsRecorder();
        }

        @Override
        public StatsCollectionState getState() {
            return StatsCollectionState.DISABLED;
        }

        @Override
        public void setState(StatsCollectionState state) {
            Preconditions.checkNotNull((Object)((Object)state), (Object)"state");
        }
    }
}

