/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.p4plugin.runtime.impl;

import java.math.BigInteger;
import java.util.concurrent.Future;
import org.opendaylight.p4plugin.runtime.impl.cluster.ElectionId;
import org.opendaylight.p4plugin.runtime.impl.cluster.ElectionIdGenerator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.cluster.rev170808.GetElectionIdOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.cluster.rev170808.GetElectionIdOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.cluster.rev170808.P4pluginClusterService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.cluster.rev170808.SetElectionIdInput;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterServiceProvider
implements P4pluginClusterService {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterServiceProvider.class);

    public Future<RpcResult<Void>> setElectionId(SetElectionIdInput input) {
        long high = input.getHigh().longValue();
        long low = input.getLow().longValue();
        ElectionIdGenerator.getInstance().setElectionId(new ElectionId(high, low));
        LOG.info("Set election ID RPC success, high = {}, low = {}.", (Object)high, (Object)low);
        return RpcResultBuilder.success((Object)null).buildFuture();
    }

    public Future<RpcResult<GetElectionIdOutput>> getElectionId() {
        ElectionId electionId = ElectionIdGenerator.getInstance().getElectionId();
        GetElectionIdOutputBuilder builder = new GetElectionIdOutputBuilder();
        builder.setHigh(BigInteger.valueOf(electionId.getHigh()));
        builder.setLow(BigInteger.valueOf(electionId.getLow()));
        LOG.info("Get election ID RPC success, high = {}, low = {}.", (Object)electionId.getHigh(), (Object)electionId.getLow());
        return RpcResultBuilder.success((Object)builder.build()).buildFuture();
    }
}

