/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.p4plugin.runtime.impl;

import com.google.protobuf.TextFormat;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.opendaylight.p4plugin.p4info.proto.P4Info;
import org.opendaylight.p4plugin.runtime.impl.device.DeviceManager;
import org.opendaylight.p4plugin.runtime.impl.device.P4Device;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.device.rev170808.AddDeviceInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.device.rev170808.ConnectToDeviceInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.device.rev170808.ConnectToDeviceOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.device.rev170808.ConnectToDeviceOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.device.rev170808.GetPipelineConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.device.rev170808.GetPipelineConfigOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.device.rev170808.GetPipelineConfigOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.device.rev170808.P4pluginDeviceService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.device.rev170808.QueryDevicesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.device.rev170808.QueryDevicesOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.device.rev170808.RemoveDeviceInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.device.rev170808.SetPipelineConfigInput;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceServiceProvider
implements P4pluginDeviceService {
    private static final Logger LOG = LoggerFactory.getLogger(DeviceServiceProvider.class);
    private DeviceManager manager;
    private ExecutorService executorService;

    public void init() {
        this.executorService = Executors.newFixedThreadPool(1);
        this.manager = DeviceManager.getInstance();
        LOG.info("P4plugin device service provider initiated.");
    }

    public void close() {
        this.executorService.shutdown();
        LOG.info("P4plugin device service provider closed.");
    }

    private <T> RpcResult<T> rpcResultSuccess(T value) {
        return RpcResultBuilder.success(value).build();
    }

    private Callable<RpcResult<Void>> addDev(AddDeviceInput input) {
        return () -> {
            String nodeId = input.getNid();
            String ip = input.getIp().getValue();
            Integer port = input.getPort().getValue();
            Long deviceId = input.getDid().longValue();
            String runtimeFile = input.getRuntimeFilePath();
            String configFile = input.getConfigFilePath();
            this.manager.addDevice(nodeId, deviceId, ip, port, runtimeFile, configFile);
            LOG.info("Add device = [{}-{}-{}:{}-{}-{}] RPC success.", new Object[]{nodeId, deviceId, ip, port, runtimeFile, configFile});
            return this.rpcResultSuccess(null);
        };
    }

    private Callable<RpcResult<Void>> removeDev(RemoveDeviceInput input) {
        return () -> {
            this.manager.removeDevice(input.getNid());
            LOG.info("Remove device = {} RPC success.", (Object)input.getNid());
            return this.rpcResultSuccess(null);
        };
    }

    private Callable<RpcResult<ConnectToDeviceOutput>> connectToDev(ConnectToDeviceInput input) {
        return () -> {
            String nodeId = input.getNid();
            Optional<P4Device> optional = this.manager.findDevice(nodeId);
            optional.orElseThrow(IllegalArgumentException::new).connectToDevice();
            boolean connectStatus = optional.get().getConnectState();
            LOG.info("Connect to device = {} RPC success, connect state = {}.", (Object)nodeId, (Object)connectStatus);
            ConnectToDeviceOutputBuilder outputBuilder = new ConnectToDeviceOutputBuilder();
            outputBuilder.setConnectStatus(Boolean.valueOf(connectStatus));
            return this.rpcResultSuccess(outputBuilder.build());
        };
    }

    private Callable<RpcResult<Void>> setConfig(SetPipelineConfigInput input) {
        return () -> {
            String nodeId = input.getNid();
            Optional<P4Device> optional = this.manager.findDevice(nodeId);
            optional.orElseThrow(IllegalArgumentException::new).setPipelineConfig();
            LOG.info("Set device = {} pipeline config RPC success.", (Object)nodeId);
            return this.rpcResultSuccess(null);
        };
    }

    private Callable<RpcResult<GetPipelineConfigOutput>> getConfig(GetPipelineConfigInput input) {
        return () -> {
            String nodeId = input.getNid();
            Optional<P4Device> optional = this.manager.findConfiguredDevice(nodeId);
            P4Info p4info = optional.orElseThrow(IllegalArgumentException::new).getPipelineConfig().getConfigs(0).getP4Info();
            String result = TextFormat.printToString(p4info);
            GetPipelineConfigOutputBuilder outputBuilder = new GetPipelineConfigOutputBuilder();
            outputBuilder.setP4Info(result);
            LOG.info("Get device = {} pipeline config RPC success.", (Object)nodeId);
            return this.rpcResultSuccess(outputBuilder.build());
        };
    }

    private Callable<RpcResult<QueryDevicesOutput>> queryDevs() {
        return () -> {
            QueryDevicesOutputBuilder outputBuilder = new QueryDevicesOutputBuilder();
            outputBuilder.setNode(this.manager.queryNodes());
            LOG.info("Query devices RPC success.");
            return this.rpcResultSuccess(outputBuilder.build());
        };
    }

    public Future<RpcResult<Void>> addDevice(AddDeviceInput input) {
        return this.executorService.submit(this.addDev(input));
    }

    public Future<RpcResult<Void>> removeDevice(RemoveDeviceInput input) {
        return this.executorService.submit(this.removeDev(input));
    }

    public Future<RpcResult<ConnectToDeviceOutput>> connectToDevice(ConnectToDeviceInput input) {
        return this.executorService.submit(this.connectToDev(input));
    }

    public Future<RpcResult<Void>> setPipelineConfig(SetPipelineConfigInput input) {
        return this.executorService.submit(this.setConfig(input));
    }

    public Future<RpcResult<GetPipelineConfigOutput>> getPipelineConfig(GetPipelineConfigInput input) {
        return this.executorService.submit(this.getConfig(input));
    }

    public Future<RpcResult<QueryDevicesOutput>> queryDevices() {
        return this.executorService.submit(this.queryDevs());
    }
}

