/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.p4plugin.runtime.impl;

import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.opendaylight.p4plugin.runtime.impl.device.DeviceManager;
import org.opendaylight.p4plugin.runtime.impl.device.P4Device;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.packet.rev170808.P4TransmitPacketInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.packet.rev170808.P4pluginPacketService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketServiceProvider
implements P4pluginPacketService {
    private static final Logger LOG = LoggerFactory.getLogger(PacketServiceProvider.class);
    private DeviceManager manager;
    private ExecutorService executorService;

    public void init() {
        this.executorService = Executors.newFixedThreadPool(1);
        this.manager = DeviceManager.getInstance();
        LOG.info("P4plugin packet service provider initiated.");
    }

    public void close() {
        this.executorService.shutdown();
        LOG.info("P4plugin packet service provider closed.");
    }

    public Future<RpcResult<Void>> p4TransmitPacket(P4TransmitPacketInput input) {
        return this.executorService.submit(() -> {
            String nodeId = input.getNid();
            Optional<P4Device> optional = this.manager.findConfiguredDevice(nodeId);
            optional.orElseThrow(IllegalArgumentException::new).transmitPacket(input.getPayload());
            LOG.info("Transmit packet to device = {} RPC success.", (Object)nodeId);
            return RpcResultBuilder.success((Object)null).build();
        });
    }
}

