/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.p4plugin.runtime.impl;

import io.grpc.StatusRuntimeException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.NotificationPublishService;
import org.opendaylight.p4plugin.runtime.impl.device.DeviceManager;
import org.opendaylight.p4plugin.runtime.impl.utils.NotificationPublisher;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ActionProfileGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ActionProfileGroupKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ActionProfileMember;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ActionProfileMemberKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.AddActionProfileGroupInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.AddActionProfileMemberInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.AddTableEntryInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.DeleteActionProfileGroupInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.DeleteActionProfileMemberInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.DeleteTableEntryInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ModifyActionProfileGroupInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ModifyActionProfileMemberInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ModifyTableEntryInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.P4pluginRuntimeService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ReadActionProfileGroupInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ReadActionProfileGroupOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ReadActionProfileGroupOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ReadActionProfileMemberInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ReadActionProfileMemberOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ReadActionProfileMemberOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ReadTableEntryInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ReadTableEntryOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ReadTableEntryOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.TableEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.TableEntryKey;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeServiceProvider
implements P4pluginRuntimeService {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeServiceProvider.class);
    private final DataBroker dataBroker;
    private final NotificationPublishService notificationPublishService;
    private DeviceManager manager;
    private ExecutorService executorService;

    public RuntimeServiceProvider(DataBroker dataBroker, NotificationPublishService notificationPublishService) {
        this.dataBroker = dataBroker;
        this.notificationPublishService = notificationPublishService;
    }

    public void init() {
        NotificationPublisher.getInstance().setNotificationService(this.notificationPublishService);
        this.executorService = Executors.newFixedThreadPool(2);
        this.manager = DeviceManager.getInstance();
        LOG.info("P4Plugin runtime service provider initiated.");
    }

    public void close() {
        this.executorService.shutdown();
        LOG.info("P4Plugin runtime service provider closed.");
    }

    private String getErrMsg(StatusRuntimeException e) {
        return String.format("RPC exception, Status = %s, Reason = %s", e.getStatus(), e.getMessage());
    }

    private <T> RpcResult<T> rpcResultFailed(String errMsg) {
        return RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, errMsg).build();
    }

    private <T> RpcResult<T> rpcResultSuccess(T value) {
        return RpcResultBuilder.success(value).build();
    }

    private Callable<RpcResult<Void>> addEntry(AddTableEntryInput input) {
        return () -> {
            String nodeId = input.getNid();
            this.manager.findConfiguredDevice(nodeId).orElseThrow(IllegalArgumentException::new).addTableEntry((TableEntry)input);
            LOG.info("Add entry to device = {} RPC success.", (Object)nodeId);
            return this.rpcResultSuccess(null);
        };
    }

    private Callable<RpcResult<Void>> modifyEntry(ModifyTableEntryInput input) {
        return () -> {
            String nodeId = input.getNid();
            this.manager.findConfiguredDevice(nodeId).orElseThrow(IllegalArgumentException::new).modifyTableEntry((TableEntry)input);
            LOG.info("Modify entry to device = {} RPC success.", (Object)nodeId);
            return this.rpcResultSuccess(null);
        };
    }

    private Callable<RpcResult<Void>> deleteEntry(DeleteTableEntryInput input) {
        return () -> {
            String nodeId = input.getNid();
            this.manager.findConfiguredDevice(nodeId).orElseThrow(IllegalArgumentException::new).deleteTableEntry((TableEntryKey)input);
            LOG.info("Delete entry from device = {} RPC success.", (Object)nodeId);
            return this.rpcResultSuccess(null);
        };
    }

    private Callable<RpcResult<Void>> addMember(AddActionProfileMemberInput input) {
        return () -> {
            String nodeId = input.getNid();
            this.manager.findConfiguredDevice(nodeId).orElseThrow(IllegalArgumentException::new).addActionProfileMember((ActionProfileMember)input);
            LOG.info("Add member to device = {} RPC success.", (Object)nodeId);
            return this.rpcResultSuccess(null);
        };
    }

    private Callable<RpcResult<Void>> modifyMember(ModifyActionProfileMemberInput input) {
        return () -> {
            String nodeId = input.getNid();
            this.manager.findConfiguredDevice(nodeId).orElseThrow(IllegalArgumentException::new).modifyActionProfileMember((ActionProfileMember)input);
            LOG.info("Modify member to device = {} RPC success.", (Object)nodeId);
            return this.rpcResultSuccess(null);
        };
    }

    private Callable<RpcResult<Void>> deleteMember(DeleteActionProfileMemberInput input) {
        return () -> {
            String nodeId = input.getNid();
            this.manager.findConfiguredDevice(nodeId).orElseThrow(IllegalArgumentException::new).deleteActionProfileMember((ActionProfileMemberKey)input);
            LOG.info("Delete member from device = {} RPC success.", (Object)nodeId);
            return this.rpcResultSuccess(null);
        };
    }

    private Callable<RpcResult<Void>> addGroup(AddActionProfileGroupInput input) {
        return () -> {
            String nodeId = input.getNid();
            this.manager.findConfiguredDevice(nodeId).orElseThrow(IllegalArgumentException::new).addActionProfileGroup((ActionProfileGroup)input);
            LOG.info("Add group to device = {} RPC success.", (Object)nodeId);
            return this.rpcResultSuccess(null);
        };
    }

    private Callable<RpcResult<Void>> modifyGroup(ModifyActionProfileGroupInput input) {
        return () -> {
            String nodeId = input.getNid();
            this.manager.findConfiguredDevice(nodeId).orElseThrow(IllegalArgumentException::new).modifyActionProfileGroup((ActionProfileGroup)input);
            LOG.info("Modify group to device = {} RPC success.", (Object)nodeId);
            return this.rpcResultSuccess(null);
        };
    }

    private Callable<RpcResult<Void>> deleteGroup(DeleteActionProfileGroupInput input) {
        return () -> {
            String nodeId = input.getNid();
            this.manager.findConfiguredDevice(nodeId).orElseThrow(IllegalArgumentException::new).deleteActionProfileGroup((ActionProfileGroupKey)input);
            LOG.info("Delete group from device = {} RPC success.", (Object)nodeId);
            return this.rpcResultSuccess(null);
        };
    }

    private Callable<RpcResult<ReadTableEntryOutput>> readEntry(ReadTableEntryInput input) {
        return () -> {
            String nodeId = input.getNid();
            ReadTableEntryOutputBuilder outputBuilder = new ReadTableEntryOutputBuilder();
            List<String> result = this.manager.findConfiguredDevice(nodeId).orElseThrow(IllegalArgumentException::new).readTableEntry(input.getTableName());
            outputBuilder.setEntry(result);
            LOG.info("Read entry from device = {} RPC success.", (Object)nodeId);
            return RpcResultBuilder.success((Object)outputBuilder.build()).build();
        };
    }

    private Callable<RpcResult<ReadActionProfileMemberOutput>> readMember(ReadActionProfileMemberInput input) {
        return () -> {
            String nodeId = input.getNid();
            ReadActionProfileMemberOutputBuilder outputBuilder = new ReadActionProfileMemberOutputBuilder();
            List<String> result = this.manager.findConfiguredDevice(nodeId).orElseThrow(IllegalArgumentException::new).readActionProfileMember(input.getActionProfileName());
            outputBuilder.setMember(result);
            LOG.info("Read member from device = {} RPC success.", (Object)nodeId);
            return RpcResultBuilder.success((Object)outputBuilder.build()).build();
        };
    }

    private Callable<RpcResult<ReadActionProfileGroupOutput>> readGroup(ReadActionProfileGroupInput input) {
        return () -> {
            String nodeId = input.getNid();
            ReadActionProfileGroupOutputBuilder outputBuilder = new ReadActionProfileGroupOutputBuilder();
            List<String> result = this.manager.findConfiguredDevice(nodeId).orElseThrow(IllegalArgumentException::new).readActionProfileGroup(input.getActionProfileName());
            outputBuilder.setGroup(result);
            LOG.info("Read group from device = {} RPC success.", (Object)nodeId);
            return RpcResultBuilder.success((Object)outputBuilder.build()).build();
        };
    }

    public Future<RpcResult<Void>> addTableEntry(AddTableEntryInput input) {
        return this.executorService.submit(this.addEntry(input));
    }

    public Future<RpcResult<Void>> modifyTableEntry(ModifyTableEntryInput input) {
        return this.executorService.submit(this.modifyEntry(input));
    }

    public Future<RpcResult<Void>> deleteTableEntry(DeleteTableEntryInput input) {
        return this.executorService.submit(this.deleteEntry(input));
    }

    public Future<RpcResult<Void>> addActionProfileMember(AddActionProfileMemberInput input) {
        return this.executorService.submit(this.addMember(input));
    }

    public Future<RpcResult<Void>> modifyActionProfileMember(ModifyActionProfileMemberInput input) {
        return this.executorService.submit(this.modifyMember(input));
    }

    public Future<RpcResult<Void>> deleteActionProfileMember(DeleteActionProfileMemberInput input) {
        return this.executorService.submit(this.deleteMember(input));
    }

    public Future<RpcResult<Void>> addActionProfileGroup(AddActionProfileGroupInput input) {
        return this.executorService.submit(this.addGroup(input));
    }

    public Future<RpcResult<Void>> modifyActionProfileGroup(ModifyActionProfileGroupInput input) {
        return this.executorService.submit(this.modifyGroup(input));
    }

    public Future<RpcResult<Void>> deleteActionProfileGroup(DeleteActionProfileGroupInput input) {
        return this.executorService.submit(this.deleteGroup(input));
    }

    public Future<RpcResult<ReadTableEntryOutput>> readTableEntry(ReadTableEntryInput input) {
        return this.executorService.submit(this.readEntry(input));
    }

    public Future<RpcResult<ReadActionProfileMemberOutput>> readActionProfileMember(ReadActionProfileMemberInput input) {
        return this.executorService.submit(this.readMember(input));
    }

    public Future<RpcResult<ReadActionProfileGroupOutput>> readActionProfileGroup(ReadActionProfileGroupInput input) {
        return this.executorService.submit(this.readGroup(input));
    }
}

