/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.p4plugin.runtime.impl.cluster;

import java.util.ArrayList;
import org.opendaylight.p4plugin.runtime.impl.cluster.ElectionId;
import org.opendaylight.p4plugin.runtime.impl.cluster.ElectionIdObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElectionIdGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(ElectionIdGenerator.class);
    private static ElectionIdGenerator singleton = new ElectionIdGenerator();
    private ElectionId electionId;
    private ArrayList<ElectionIdObserver> observers = new ArrayList();

    private ElectionIdGenerator() {
        this.electionId = new ElectionId(0L, 0L);
    }

    public static ElectionIdGenerator getInstance() {
        return singleton;
    }

    public ElectionId getElectionId() {
        return this.electionId;
    }

    public void setElectionId(ElectionId electionId) {
        this.electionId = electionId;
        this.notifyObservers();
    }

    public void addObserver(ElectionIdObserver observer) {
        this.observers.add(observer);
    }

    public void deleteObserver(ElectionIdObserver observer) {
        this.observers.remove(observer);
    }

    private void notifyObservers() {
        this.observers.forEach(observer -> observer.update(this.electionId));
    }
}

