/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.p4plugin.runtime.impl.device;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.p4plugin.p4info.proto.P4Info;
import org.opendaylight.p4plugin.runtime.impl.device.P4Device;
import org.opendaylight.p4plugin.runtime.impl.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceManager {
    private static final Logger LOG = LoggerFactory.getLogger(DeviceManager.class);
    private static DeviceManager singleton = new DeviceManager();
    private volatile ConcurrentHashMap<String, P4Device> devices = new ConcurrentHashMap();

    private DeviceManager() {
    }

    public static DeviceManager getInstance() {
        return singleton;
    }

    public boolean isNodeExist(String nodeId) {
        return ((ConcurrentHashMap.KeySetView)this.devices.keySet()).contains(nodeId);
    }

    public boolean isTargetExist(String ip, Integer port, Long deviceId) {
        Optional<String> keyContainer = this.devices.keySet().stream().filter(k -> this.devices.get(k).getDeviceId().equals(deviceId) && this.devices.get(k).getIp().equals(ip) && this.devices.get(k).getPort().equals(port)).findFirst();
        return keyContainer.isPresent();
    }

    public boolean isDeviceExist(String nodeId, String ip, Integer port, Long deviceId) {
        return this.isNodeExist(nodeId) && this.isTargetExist(ip, port, deviceId);
    }

    public Optional<P4Device> findDevice(String nodeId) {
        return Optional.ofNullable(this.devices.get(nodeId));
    }

    public synchronized void addDevice(String nodeId, Long deviceId, String ip, Integer port, String runtimeFile, String configFile) throws IOException {
        if (this.isDeviceExist(nodeId, ip, port, deviceId)) {
            throw new IllegalArgumentException("Device is existed.");
        }
        P4Info p4Info = Utils.parseRuntimeInfo(runtimeFile);
        ByteString config = Utils.parseDeviceConfigInfo(configFile);
        P4Device.Builder builder = P4Device.newBuilder().setNodeId(nodeId).setDeviceId(deviceId).setRuntimeInfo(p4Info).setDeviceConfig(config).setIp(ip).setPort(port);
        this.devices.put(nodeId, builder.build());
    }

    public synchronized void removeDevice(String nodeId) {
        Optional<P4Device> optional = this.findDevice(nodeId);
        optional.ifPresent(device -> {
            device.shutdown();
            this.devices.remove(nodeId);
            LOG.info("Device = [{}] removed.", (Object)device.getNodeId());
        });
    }

    public Optional<P4Device> findConfiguredDevice(String nodeId) {
        Optional<P4Device> optional = this.findDevice(nodeId);
        if (optional.isPresent() && optional.get().isConfigured()) {
            return optional;
        }
        LOG.info("Cannot find a configured device, node id = {}.", (Object)nodeId);
        return Optional.empty();
    }

    public List<String> queryNodes() {
        ArrayList<String> result = new ArrayList<String>();
        ((ConcurrentHashMap.KeySetView)this.devices.keySet()).forEach(node -> {
            P4Device device = this.devices.get(node);
            result.add(device.toString());
        });
        return result;
    }
}

