/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.p4plugin.runtime.impl.device;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.util.JsonFormat;
import io.grpc.ConnectivityState;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.opendaylight.p4plugin.p4config.proto.P4DeviceConfig;
import org.opendaylight.p4plugin.p4info.proto.Action;
import org.opendaylight.p4plugin.p4info.proto.ActionProfile;
import org.opendaylight.p4plugin.p4info.proto.MatchField;
import org.opendaylight.p4plugin.p4info.proto.P4Info;
import org.opendaylight.p4plugin.p4info.proto.Table;
import org.opendaylight.p4plugin.p4runtime.proto.Action;
import org.opendaylight.p4plugin.p4runtime.proto.ActionProfileGroup;
import org.opendaylight.p4plugin.p4runtime.proto.ActionProfileMember;
import org.opendaylight.p4plugin.p4runtime.proto.Entity;
import org.opendaylight.p4plugin.p4runtime.proto.FieldMatch;
import org.opendaylight.p4plugin.p4runtime.proto.ForwardingPipelineConfig;
import org.opendaylight.p4plugin.p4runtime.proto.GetForwardingPipelineConfigRequest;
import org.opendaylight.p4plugin.p4runtime.proto.GetForwardingPipelineConfigResponse;
import org.opendaylight.p4plugin.p4runtime.proto.ReadRequest;
import org.opendaylight.p4plugin.p4runtime.proto.ReadResponse;
import org.opendaylight.p4plugin.p4runtime.proto.SetForwardingPipelineConfigRequest;
import org.opendaylight.p4plugin.p4runtime.proto.SetForwardingPipelineConfigResponse;
import org.opendaylight.p4plugin.p4runtime.proto.TableAction;
import org.opendaylight.p4plugin.p4runtime.proto.TableEntry;
import org.opendaylight.p4plugin.p4runtime.proto.Update;
import org.opendaylight.p4plugin.p4runtime.proto.WriteRequest;
import org.opendaylight.p4plugin.p4runtime.proto.WriteResponse;
import org.opendaylight.p4plugin.runtime.impl.stub.RuntimeStub;
import org.opendaylight.p4plugin.runtime.impl.utils.Utils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ActionProfileGroupKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ActionProfileMemberKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.TableEntryKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.match.field.Field;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.match.field.field.MatchType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.match.field.field.match.type.EXACT;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.match.field.field.match.type.LPM;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.match.field.field.match.type.RANGE;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.match.field.field.match.type.TERNARY;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.table.entry.ActionType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.table.entry.action.type.ACTIONPROFILEGROUP;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.table.entry.action.type.ACTIONPROFILEMEMBER;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.table.entry.action.type.DIRECTACTION;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P4Device {
    private static final Logger LOG = LoggerFactory.getLogger(P4Device.class);
    private RuntimeStub runtimeStub;
    private P4Info runtimeInfo;
    private ByteString deviceConfig;
    private String ip;
    private Integer port;
    private Long deviceId;
    private String nodeId;
    private boolean isConfigured;

    private P4Device(String ip, Integer port, Long deviceId, String nodeId, P4Info runtimeInfo, ByteString deviceConfig) {
        this.ip = ip;
        this.port = port;
        this.deviceId = deviceId;
        this.nodeId = nodeId;
        this.runtimeInfo = runtimeInfo;
        this.deviceConfig = deviceConfig;
    }

    public boolean getConnectState() {
        return this.runtimeStub.getConnectState();
    }

    public boolean isConfigured() {
        return this.runtimeInfo != null && this.deviceConfig != null && this.isConfigured;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Long getDeviceId() {
        return this.deviceId;
    }

    public String getIp() {
        return this.ip;
    }

    public Integer getPort() {
        return this.port;
    }

    private int getTableId(String tableName) {
        Optional<Table> optional = this.runtimeInfo.getTablesList().stream().filter(table -> table.getPreamble().getName().equals(tableName)).findFirst();
        return optional.orElseThrow(() -> new IllegalArgumentException("Invalid table name")).getPreamble().getId();
    }

    private String getTableName(int tableId) {
        Optional<Table> optional = this.runtimeInfo.getTablesList().stream().filter(table -> table.getPreamble().getId() == tableId).findFirst();
        return optional.orElseThrow(() -> new IllegalArgumentException("Invalid table id")).getPreamble().getName();
    }

    private int getMatchFieldId(String tableName, String matchFieldName) {
        Optional<Table> tableContainer = this.runtimeInfo.getTablesList().stream().filter(table -> table.getPreamble().getName().equals(tableName)).findFirst();
        Optional<MatchField> matchFieldContainer = tableContainer.orElseThrow(() -> new IllegalArgumentException("Invalid table name")).getMatchFieldsList().stream().filter(matchField -> matchField.getName().equals(matchFieldName)).findFirst();
        return matchFieldContainer.orElseThrow(() -> new IllegalArgumentException("Invalid match field name")).getId();
    }

    private String getMatchFieldName(int tableId, int matchFieldId) {
        Optional<Table> tableContainer = this.runtimeInfo.getTablesList().stream().filter(table -> table.getPreamble().getId() == tableId).findFirst();
        Optional<MatchField> matchFieldContainer = tableContainer.orElseThrow(() -> new IllegalArgumentException("Invalid table id")).getMatchFieldsList().stream().filter(matchField -> matchField.getId() == matchFieldId).findFirst();
        return matchFieldContainer.orElseThrow(() -> new IllegalArgumentException("Invalid match field id")).getName();
    }

    private int getMatchFieldWidth(String tableName, String matchFieldName) {
        Optional<Table> tableContainer = this.runtimeInfo.getTablesList().stream().filter(table -> table.getPreamble().getName().equals(tableName)).findFirst();
        Optional<MatchField> matchFieldContainer = tableContainer.orElseThrow(() -> new IllegalArgumentException("Invalid table name")).getMatchFieldsList().stream().filter(matchField -> matchField.getName().equals(matchFieldName)).findFirst();
        return (matchFieldContainer.orElseThrow(() -> new IllegalArgumentException("Invalid match field name")).getBitwidth() + 7) / 8;
    }

    private int getActionId(String actionName) {
        Optional<Action> optional = this.runtimeInfo.getActionsList().stream().filter(action -> action.getPreamble().getName().equals(actionName)).findFirst();
        return optional.orElseThrow(() -> new IllegalArgumentException("Invalid action name")).getPreamble().getId();
    }

    private String getActionName(int actionId) {
        Optional<Action> optional = this.runtimeInfo.getActionsList().stream().filter(action -> action.getPreamble().getId() == actionId).findFirst();
        return optional.orElseThrow(() -> new IllegalArgumentException("Invalid action id")).getPreamble().getName();
    }

    private int getParamId(String actionName, String paramName) {
        Optional<Action> actionContainer = this.runtimeInfo.getActionsList().stream().filter(action -> action.getPreamble().getName().equals(actionName)).findFirst();
        Optional<Action.Param> paramContainer = actionContainer.orElseThrow(() -> new IllegalArgumentException("Invalid action name")).getParamsList().stream().filter(param -> param.getName().equals(paramName)).findFirst();
        return paramContainer.orElseThrow(() -> new IllegalArgumentException("Invalid param name")).getId();
    }

    private String getParamName(int actionId, int paramId) {
        Optional<Action> actionContainer = this.runtimeInfo.getActionsList().stream().filter(action -> action.getPreamble().getId() == actionId).findFirst();
        Optional<Action.Param> paramContainer = actionContainer.orElseThrow(() -> new IllegalArgumentException("Invalid action id")).getParamsList().stream().filter(param -> param.getId() == paramId).findFirst();
        return paramContainer.orElseThrow(() -> new IllegalArgumentException("Invalid param id")).getName();
    }

    private int getParamWidth(String actionName, String paramName) {
        Optional<Action> actionContainer = this.runtimeInfo.getActionsList().stream().filter(action -> action.getPreamble().getName().equals(actionName)).findFirst();
        Optional<Action.Param> paramContainer = actionContainer.orElseThrow(() -> new IllegalArgumentException("Invalid action name")).getParamsList().stream().filter(param -> param.getName().equals(paramName)).findFirst();
        return (paramContainer.orElseThrow(() -> new IllegalArgumentException("Invalid param name")).getBitwidth() + 7) / 8;
    }

    private int getActionProfileId(String actionProfileName) {
        Optional<ActionProfile> optional = this.runtimeInfo.getActionProfilesList().stream().filter(actionProfile -> actionProfile.getPreamble().getName().equals(actionProfileName)).findFirst();
        return optional.orElseThrow(() -> new IllegalArgumentException("Invalid action profile name")).getPreamble().getId();
    }

    private String getActionProfileName(Integer actionProfileId) {
        Optional<ActionProfile> optional = this.runtimeInfo.getActionProfilesList().stream().filter(actionProfile -> actionProfile.getPreamble().getId() == actionProfileId.intValue()).findFirst();
        return optional.orElseThrow(() -> new IllegalArgumentException("Invalid action profile id")).getPreamble().getName();
    }

    public SetForwardingPipelineConfigResponse setPipelineConfig() {
        ForwardingPipelineConfig.Builder configBuilder = ForwardingPipelineConfig.newBuilder();
        P4DeviceConfig.Builder p4DeviceConfigBuilder = P4DeviceConfig.newBuilder();
        p4DeviceConfigBuilder.setDeviceData(this.deviceConfig);
        configBuilder.setP4Info(this.runtimeInfo);
        configBuilder.setP4DeviceConfig(p4DeviceConfigBuilder.build().toByteString());
        configBuilder.setDeviceId(this.deviceId);
        SetForwardingPipelineConfigRequest request = SetForwardingPipelineConfigRequest.newBuilder().setAction(SetForwardingPipelineConfigRequest.Action.VERIFY_AND_COMMIT).addConfigs(configBuilder).build();
        SetForwardingPipelineConfigResponse response = this.runtimeStub.setPipelineConfig(request);
        this.isConfigured = true;
        return response;
    }

    public GetForwardingPipelineConfigResponse getPipelineConfig() {
        GetForwardingPipelineConfigRequest request = GetForwardingPipelineConfigRequest.newBuilder().addDeviceIds(this.deviceId).build();
        GetForwardingPipelineConfigResponse response = this.runtimeStub.getPipelineConfig(request);
        return response;
    }

    private WriteRequest createWriteRequest(TableEntry entry, Update.Type type) {
        WriteRequest.Builder requestBuilder = WriteRequest.newBuilder();
        Update.Builder updateBuilder = Update.newBuilder();
        Entity.Builder entityBuilder = Entity.newBuilder();
        entityBuilder.setTableEntry(entry);
        updateBuilder.setType(type);
        updateBuilder.setEntity(entityBuilder);
        requestBuilder.setDeviceId(this.deviceId);
        requestBuilder.addUpdates(updateBuilder);
        return requestBuilder.build();
    }

    private WriteRequest createWriteRequest(ActionProfileGroup group, Update.Type type) {
        WriteRequest.Builder requestBuilder = WriteRequest.newBuilder();
        Update.Builder updateBuilder = Update.newBuilder();
        Entity.Builder entityBuilder = Entity.newBuilder();
        entityBuilder.setActionProfileGroup(group);
        updateBuilder.setEntity(entityBuilder);
        updateBuilder.setType(type);
        requestBuilder.setDeviceId(this.deviceId);
        requestBuilder.addUpdates(updateBuilder);
        return requestBuilder.build();
    }

    private WriteRequest createWriteRequest(ActionProfileMember member, Update.Type type) {
        WriteRequest.Builder requestBuilder = WriteRequest.newBuilder();
        Update.Builder updateBuilder = Update.newBuilder();
        Entity.Builder entityBuilder = Entity.newBuilder();
        entityBuilder.setActionProfileMember(member);
        updateBuilder.setType(type);
        updateBuilder.setEntity(entityBuilder);
        requestBuilder.setDeviceId(this.deviceId);
        requestBuilder.addUpdates(updateBuilder);
        return requestBuilder.build();
    }

    public WriteResponse addTableEntry(org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.TableEntry inputEntry) {
        WriteRequest request = this.createWriteRequest(this.toProtoEntry(inputEntry), Update.Type.INSERT);
        WriteResponse response = this.write(request);
        return response;
    }

    public WriteResponse modifyTableEntry(org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.TableEntry inputEntry) {
        WriteRequest request = this.createWriteRequest(this.toProtoEntry(inputEntry), Update.Type.MODIFY);
        WriteResponse response = this.write(request);
        return response;
    }

    public WriteResponse deleteTableEntry(TableEntryKey inputEntryKey) {
        WriteRequest request = this.createWriteRequest(this.toProtoEntry(inputEntryKey), Update.Type.DELETE);
        WriteResponse response = this.write(request);
        return response;
    }

    public List<String> readTableEntry(String tableName) {
        ReadRequest.Builder request = ReadRequest.newBuilder();
        Entity.Builder entityBuilder = Entity.newBuilder();
        TableEntry.Builder entryBuilder = TableEntry.newBuilder();
        entryBuilder.setTableId(this.getTableId(tableName));
        entityBuilder.setTableEntry(entryBuilder);
        request.addEntities(entityBuilder);
        request.setDeviceId(this.deviceId);
        Iterator<ReadResponse> responses = this.read(request.build());
        ArrayList<String> result = new ArrayList<String>();
        while (responses.hasNext()) {
            ReadResponse response = responses.next();
            List<Entity> entityList = response.getEntitiesList();
            boolean isCompleted = response.getComplete();
            entityList.forEach(entity -> {
                String str = this.toStringEntry(entity.getTableEntry());
                result.add(str);
            });
            if (!isCompleted) continue;
            break;
        }
        return result;
    }

    public WriteResponse addActionProfileMember(org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ActionProfileMember inputMember) {
        WriteRequest request = this.createWriteRequest(this.toProtoMember(inputMember), Update.Type.INSERT);
        WriteResponse response = this.write(request);
        return response;
    }

    public WriteResponse modifyActionProfileMember(org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ActionProfileMember inputMember) {
        WriteRequest request = this.createWriteRequest(this.toProtoMember(inputMember), Update.Type.MODIFY);
        WriteResponse response = this.write(request);
        return response;
    }

    public WriteResponse deleteActionProfileMember(ActionProfileMemberKey inputMemberKey) {
        WriteRequest request = this.createWriteRequest(this.toProtoMember(inputMemberKey), Update.Type.DELETE);
        WriteResponse response = this.write(request);
        return response;
    }

    public List<String> readActionProfileMember(String actionProfileName) {
        ReadRequest.Builder requestBuilder = ReadRequest.newBuilder();
        Entity.Builder entityBuilder = Entity.newBuilder();
        ActionProfileMember.Builder memberBuilder = ActionProfileMember.newBuilder();
        memberBuilder.setActionProfileId(this.getActionProfileId(actionProfileName));
        entityBuilder.setActionProfileMember(memberBuilder);
        requestBuilder.setDeviceId(this.deviceId);
        requestBuilder.addEntities(entityBuilder);
        Iterator<ReadResponse> responses = this.read(requestBuilder.build());
        ArrayList<String> result = new ArrayList<String>();
        while (responses.hasNext()) {
            ReadResponse response = responses.next();
            List<Entity> entityList = response.getEntitiesList();
            boolean isCompleted = response.getComplete();
            entityList.forEach(entity -> {
                String str = this.toStringMember(entity.getActionProfileMember());
                result.add(str);
            });
            if (!isCompleted) continue;
            break;
        }
        return result;
    }

    public WriteResponse addActionProfileGroup(org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ActionProfileGroup inputGroup) {
        WriteRequest request = this.createWriteRequest(this.toProtoGroup(inputGroup), Update.Type.INSERT);
        WriteResponse response = this.write(request);
        return response;
    }

    public WriteResponse modifyActionProfileGroup(org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ActionProfileGroup inputGroup) {
        WriteRequest request = this.createWriteRequest(this.toProtoGroup(inputGroup), Update.Type.MODIFY);
        WriteResponse response = this.write(request);
        return response;
    }

    public WriteResponse deleteActionProfileGroup(ActionProfileGroupKey inputGroupKey) {
        WriteRequest request = this.createWriteRequest(this.toProtoGroup(inputGroupKey), Update.Type.DELETE);
        WriteResponse response = this.write(request);
        return response;
    }

    public List<String> readActionProfileGroup(String actionProfileName) {
        ReadRequest.Builder requestBuilder = ReadRequest.newBuilder();
        Entity.Builder entityBuilder = Entity.newBuilder();
        ActionProfileGroup.Builder groupBuilder = ActionProfileGroup.newBuilder();
        groupBuilder.setActionProfileId(this.getActionProfileId(actionProfileName));
        entityBuilder.setActionProfileGroup(groupBuilder);
        requestBuilder.setDeviceId(this.deviceId);
        requestBuilder.addEntities(entityBuilder);
        Iterator<ReadResponse> responses = this.read(requestBuilder.build());
        ArrayList<String> result = new ArrayList<String>();
        while (responses.hasNext()) {
            ReadResponse response = responses.next();
            List<Entity> entityList = response.getEntitiesList();
            boolean isCompleted = response.getComplete();
            entityList.forEach(entity -> {
                String str = this.toStringGroup(entity.getActionProfileGroup());
                result.add(str);
            });
            if (!isCompleted) continue;
            break;
        }
        return result;
    }

    public WriteResponse write(WriteRequest request) {
        WriteResponse response = this.runtimeStub.write(request);
        return response;
    }

    public Iterator<ReadResponse> read(ReadRequest request) {
        Iterator<ReadResponse> responses = this.runtimeStub.read(request);
        return responses;
    }

    public void transmitPacket(byte[] payload) {
        this.runtimeStub.transmitPacket(payload);
    }

    public void connectToDevice() {
        if (this.runtimeStub != null) {
            this.runtimeStub.shutdown();
        }
        this.runtimeStub = new RuntimeStub(this.ip, this.port, this.deviceId, this.nodeId);
        this.runtimeStub.notifyWhenStateChanged(ConnectivityState.READY, () -> {
            this.isConfigured = false;
        });
        this.runtimeStub.streamChannel();
    }

    public void shutdown() {
        this.runtimeStub.shutdown();
    }

    private TableAction directActionParse(DIRECTACTION action) {
        TableAction.Builder tableActionBuilder = TableAction.newBuilder();
        Action.Builder actionBuilder = org.opendaylight.p4plugin.p4runtime.proto.Action.newBuilder();
        List params = action.getActionParam();
        String actionName = action.getActionName();
        actionBuilder.setActionId(this.getActionId(actionName));
        params.forEach(p -> {
            Action.Param.Builder paramBuilder = Action.Param.newBuilder();
            String paramName = p.getParamName();
            int paramId = this.getParamId(actionName, paramName);
            int paramWidth = this.getParamWidth(actionName, paramName);
            paramBuilder.setParamId(paramId);
            String valueStr = p.getParamValue();
            byte[] valueBytes = Utils.strToByteArray(valueStr, paramWidth);
            paramBuilder.setValue(ByteString.copyFrom(valueBytes));
            actionBuilder.addParams(paramBuilder);
        });
        return tableActionBuilder.setAction(actionBuilder).build();
    }

    private TableAction memberActionParse(ACTIONPROFILEMEMBER memberAction) {
        TableAction.Builder builder = TableAction.newBuilder();
        builder.setActionProfileMemberId(memberAction.getMemberId().intValue());
        return builder.build();
    }

    private TableAction groupActionParse(ACTIONPROFILEGROUP groupAction) {
        TableAction.Builder builder = TableAction.newBuilder();
        builder.setActionProfileGroupId(groupAction.getGroupId().intValue());
        return builder.build();
    }

    private TableAction buildTableAction(ActionType actionType) {
        if (actionType instanceof DIRECTACTION) {
            return this.directActionParse((DIRECTACTION)actionType);
        }
        if (actionType instanceof ACTIONPROFILEMEMBER) {
            return this.memberActionParse((ACTIONPROFILEMEMBER)actionType);
        }
        if (actionType instanceof ACTIONPROFILEGROUP) {
            return this.groupActionParse((ACTIONPROFILEGROUP)actionType);
        }
        throw new IllegalArgumentException("Invalid action type");
    }

    private FieldMatch exactMatchParse(EXACT exact, String tableName, String fieldName) {
        FieldMatch.Builder fieldMatchBuilder = FieldMatch.newBuilder();
        FieldMatch.Exact.Builder exactBuilder = FieldMatch.Exact.newBuilder();
        Integer matchFieldWidth = this.getMatchFieldWidth(tableName, fieldName);
        Integer matchFieldId = this.getMatchFieldId(tableName, fieldName);
        String valueStr = exact.getExactValue().getValue();
        byte[] valeBytes = Utils.strToByteArray(valueStr, matchFieldWidth);
        exactBuilder.setValue(ByteString.copyFrom(valeBytes, 0, matchFieldWidth));
        fieldMatchBuilder.setExact(exactBuilder);
        fieldMatchBuilder.setFieldId(matchFieldId);
        return fieldMatchBuilder.build();
    }

    private FieldMatch lpmMatchParse(LPM lpm, String tableName, String fieldName) {
        FieldMatch.Builder fieldMatchBuilder = FieldMatch.newBuilder();
        FieldMatch.LPM.Builder lpmBuilder = FieldMatch.LPM.newBuilder();
        Integer matchFieldWidth = this.getMatchFieldWidth(tableName, fieldName);
        Integer matchFieldId = this.getMatchFieldId(tableName, fieldName);
        String valueStr = lpm.getLpmValue().getValue();
        byte[] valeBytes = Utils.strToByteArray(valueStr, matchFieldWidth);
        lpmBuilder.setValue(ByteString.copyFrom(valeBytes, 0, matchFieldWidth));
        lpmBuilder.setPrefixLen(lpm.getPrefixLen().intValue());
        fieldMatchBuilder.setLpm(lpmBuilder);
        fieldMatchBuilder.setFieldId(matchFieldId);
        return fieldMatchBuilder.build();
    }

    private byte[] getMask(Short mask) {
        StringBuffer buffer = new StringBuffer(128);
        for (int i = 0; i < 128; ++i) {
            if (i < mask) {
                buffer.append('1');
                continue;
            }
            buffer.append('0');
        }
        byte[] result = new byte[16];
        for (int i = 0; i < 16; ++i) {
            result[i] = (byte)Integer.parseInt(buffer.substring(i * 8, i * 8 + 8), 2);
        }
        return result;
    }

    private FieldMatch ternaryMatchParse(TERNARY ternary, String tableName, String fieldName) {
        FieldMatch.Builder fieldMatchBuilder = FieldMatch.newBuilder();
        FieldMatch.Ternary.Builder ternaryBuilder = FieldMatch.Ternary.newBuilder();
        String valueStr = new String(ternary.getTernaryValue().getValue());
        Short mask = ternary.getMask();
        Integer matchFieldWidth = this.getMatchFieldWidth(tableName, fieldName);
        Integer matchFieldId = this.getMatchFieldId(tableName, fieldName);
        byte[] valueBytes = Utils.strToByteArray(valueStr, matchFieldWidth);
        byte[] maskBytes = this.getMask(mask);
        ternaryBuilder.setValue(ByteString.copyFrom(valueBytes, 0, matchFieldWidth));
        ternaryBuilder.setMask(ByteString.copyFrom(maskBytes, 0, matchFieldWidth));
        fieldMatchBuilder.setTernary(ternaryBuilder);
        fieldMatchBuilder.setFieldId(matchFieldId);
        return fieldMatchBuilder.build();
    }

    private FieldMatch rangeMatchParse(RANGE range, String tableName, String fieldName) {
        FieldMatch.Builder fieldMatchBuilder = FieldMatch.newBuilder();
        FieldMatch.Range.Builder rangeBuilder = FieldMatch.Range.newBuilder();
        BigInteger high = range.getRangeValueHigh();
        BigInteger low = range.getRangeValueLow();
        Integer matchFieldWidth = this.getMatchFieldWidth(tableName, fieldName);
        Integer matchFieldId = this.getMatchFieldId(tableName, fieldName);
        rangeBuilder.setHigh(ByteString.copyFrom(high.toByteArray(), 0, matchFieldWidth));
        rangeBuilder.setLow(ByteString.copyFrom(low.toByteArray(), 0, matchFieldWidth));
        fieldMatchBuilder.setFieldId(matchFieldId);
        fieldMatchBuilder.setRange(rangeBuilder);
        return fieldMatchBuilder.build();
    }

    private FieldMatch buildFieldMatch(Field fields, String tableName) {
        MatchType matchType = fields.getMatchType();
        String fieldName = fields.getFieldName();
        if (matchType instanceof EXACT) {
            return this.exactMatchParse((EXACT)matchType, tableName, fieldName);
        }
        if (matchType instanceof LPM) {
            return this.lpmMatchParse((LPM)matchType, tableName, fieldName);
        }
        if (matchType instanceof TERNARY) {
            return this.ternaryMatchParse((TERNARY)matchType, tableName, fieldName);
        }
        if (matchType instanceof RANGE) {
            return this.rangeMatchParse((RANGE)matchType, tableName, fieldName);
        }
        throw new IllegalArgumentException("Invalid match type");
    }

    public TableEntry toProtoEntry(org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.TableEntry entry) {
        String tableName = entry.getTableName();
        int tableId = this.getTableId(tableName);
        TableEntry.Builder tableEntryBuilder = TableEntry.newBuilder();
        List fields = entry.getField();
        fields.forEach(field -> tableEntryBuilder.addMatch(this.buildFieldMatch((Field)field, tableName)));
        ActionType actionType = entry.getActionType();
        TableAction tableAction = this.buildTableAction(actionType);
        tableEntryBuilder.setPriority(entry.getPriority());
        tableEntryBuilder.setControllerMetadata(entry.getControllerMetadata().longValue());
        tableEntryBuilder.setTableId(tableId);
        tableEntryBuilder.setAction(tableAction);
        return tableEntryBuilder.build();
    }

    public TableEntry toProtoEntry(TableEntryKey entryKey) {
        String tableName = entryKey.getTableName();
        int tableId = this.getTableId(tableName);
        TableEntry.Builder tableEntryBuilder = TableEntry.newBuilder();
        List fields = entryKey.getField();
        fields.forEach(field -> tableEntryBuilder.addMatch(this.buildFieldMatch((Field)field, tableName)));
        tableEntryBuilder.setTableId(tableId);
        return tableEntryBuilder.build();
    }

    public ActionProfileMember toProtoMember(org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ActionProfileMember member) {
        String actionName = member.getActionName();
        Long memberId = member.getMemberId();
        String actionProfile = member.getActionProfileName();
        ActionProfileMember.Builder memberBuilder = ActionProfileMember.newBuilder();
        Action.Builder actionBuilder = org.opendaylight.p4plugin.p4runtime.proto.Action.newBuilder();
        actionBuilder.setActionId(this.getActionId(actionName));
        member.getActionParam().forEach(actionParam -> {
            Action.Param.Builder paramBuilder = Action.Param.newBuilder();
            String paramName = actionParam.getParamName();
            int paramId = this.getParamId(actionName, paramName);
            int paramWidth = this.getParamWidth(actionName, paramName);
            String valueStr = actionParam.getParamValue();
            byte[] valueBytes = Utils.strToByteArray(valueStr, paramWidth);
            paramBuilder.setValue(ByteString.copyFrom(valueBytes));
            paramBuilder.setParamId(paramId);
            actionBuilder.addParams(paramBuilder);
        });
        memberBuilder.setAction(actionBuilder);
        memberBuilder.setActionProfileId(this.getActionProfileId(actionProfile));
        memberBuilder.setMemberId(memberId.intValue());
        return memberBuilder.build();
    }

    public ActionProfileMember toProtoMember(ActionProfileMemberKey memberKey) {
        Long memberId = memberKey.getMemberId();
        String actionProfile = memberKey.getActionProfileName();
        ActionProfileMember.Builder memberBuilder = ActionProfileMember.newBuilder();
        memberBuilder.setActionProfileId(this.getActionProfileId(actionProfile));
        memberBuilder.setMemberId(memberId.intValue());
        return memberBuilder.build();
    }

    public ActionProfileGroup toProtoGroup(org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.runtime.rev170808.ActionProfileGroup group) {
        Long groupId = group.getGroupId();
        String actionProfile = group.getActionProfileName();
        Integer maxSize = group.getMaxSize();
        ActionProfileGroup.Builder groupBuilder = ActionProfileGroup.newBuilder();
        groupBuilder.setActionProfileId(this.getActionProfileId(actionProfile));
        groupBuilder.setGroupId(groupId.intValue());
        groupBuilder.setMaxSize(maxSize);
        group.getGroupMember().forEach(groupMember -> {
            ActionProfileGroup.Member.Builder builder = ActionProfileGroup.Member.newBuilder();
            builder.setWatch(groupMember.getWatch().intValue());
            builder.setWeight(groupMember.getWeight());
            builder.setMemberId(groupMember.getMemberId().intValue());
            groupBuilder.addMembers(builder);
        });
        return groupBuilder.build();
    }

    public ActionProfileGroup toProtoGroup(ActionProfileGroupKey groupKey) {
        Long groupId = groupKey.getGroupId();
        String actionProfile = groupKey.getActionProfileName();
        ActionProfileGroup.Builder groupBuilder = ActionProfileGroup.newBuilder();
        groupBuilder.setActionProfileId(this.getActionProfileId(actionProfile));
        groupBuilder.setGroupId(groupId.intValue());
        return groupBuilder.build();
    }

    public String toStringEntry(TableEntry entry) {
        try {
            String result = JsonFormat.printer().print(entry);
            return result;
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toStringMember(ActionProfileMember member) {
        try {
            String result = JsonFormat.printer().print(member);
            return result;
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toStringGroup(ActionProfileGroup group) {
        try {
            String result = JsonFormat.printer().print(group);
            return result;
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return String.format("%s/%d-%s:%d/%s/%s", this.nodeId, this.deviceId, this.ip, this.port, this.getConnectState(), this.isConfigured);
    }

    public static final class Builder {
        private P4Info runtimeInfo_;
        private ByteString deviceConfig_;
        private Long deviceId_;
        private String nodeId_;
        private String ip_;
        private Integer port_;

        public Builder setIp(String ip) {
            this.ip_ = ip;
            return this;
        }

        public Builder setPort(Integer port) {
            this.port_ = port;
            return this;
        }

        public Builder setRuntimeInfo(P4Info p4Info) {
            this.runtimeInfo_ = p4Info;
            return this;
        }

        public Builder setDeviceConfig(ByteString config) {
            this.deviceConfig_ = config;
            return this;
        }

        public Builder setDeviceId(Long deviceId) {
            this.deviceId_ = deviceId;
            return this;
        }

        public Builder setNodeId(String nodeId) {
            this.nodeId_ = nodeId;
            return this;
        }

        public P4Device build() {
            P4Device device = new P4Device(this.ip_, this.port_, this.deviceId_, this.nodeId_, this.runtimeInfo_, this.deviceConfig_);
            return device;
        }
    }
}

