/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.p4plugin.runtime.impl.stub;

import com.google.protobuf.ByteString;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.Iterator;
import org.opendaylight.p4plugin.p4runtime.proto.GetForwardingPipelineConfigRequest;
import org.opendaylight.p4plugin.p4runtime.proto.GetForwardingPipelineConfigResponse;
import org.opendaylight.p4plugin.p4runtime.proto.MasterArbitrationUpdate;
import org.opendaylight.p4plugin.p4runtime.proto.P4RuntimeGrpc;
import org.opendaylight.p4plugin.p4runtime.proto.PacketOut;
import org.opendaylight.p4plugin.p4runtime.proto.ReadRequest;
import org.opendaylight.p4plugin.p4runtime.proto.ReadResponse;
import org.opendaylight.p4plugin.p4runtime.proto.SetForwardingPipelineConfigRequest;
import org.opendaylight.p4plugin.p4runtime.proto.SetForwardingPipelineConfigResponse;
import org.opendaylight.p4plugin.p4runtime.proto.StreamMessageRequest;
import org.opendaylight.p4plugin.p4runtime.proto.StreamMessageResponse;
import org.opendaylight.p4plugin.p4runtime.proto.Uint128;
import org.opendaylight.p4plugin.p4runtime.proto.WriteRequest;
import org.opendaylight.p4plugin.p4runtime.proto.WriteResponse;
import org.opendaylight.p4plugin.runtime.impl.cluster.ElectionId;
import org.opendaylight.p4plugin.runtime.impl.cluster.ElectionIdGenerator;
import org.opendaylight.p4plugin.runtime.impl.cluster.ElectionIdObserver;
import org.opendaylight.p4plugin.runtime.impl.utils.NotificationPublisher;
import org.opendaylight.p4plugin.runtime.impl.utils.Utils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.p4plugin.packet.rev170808.P4PacketReceivedBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeStub
implements ElectionIdObserver {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeStub.class);
    private ManagedChannel channel;
    private P4RuntimeGrpc.P4RuntimeBlockingStub blockingStub;
    private P4RuntimeGrpc.P4RuntimeStub asyncStub;
    private String nodeId;
    private Long deviceId;
    private StreamObserver<StreamMessageRequest> requestStreamObserver;
    private ElectionId electionId;

    public RuntimeStub(String ip, Integer port, Long deviceId, String nodeId) {
        this((ManagedChannelBuilder<?>)ManagedChannelBuilder.forAddress(ip, port).usePlaintext(true), deviceId, nodeId);
    }

    private RuntimeStub(ManagedChannelBuilder<?> channelBuilder, Long deviceId, String nodeId) {
        this.channel = channelBuilder.build();
        this.nodeId = nodeId;
        this.deviceId = deviceId;
        this.initStub();
        this.initElectionId();
    }

    private void initStub() {
        this.blockingStub = P4RuntimeGrpc.newBlockingStub(this.channel);
        this.asyncStub = P4RuntimeGrpc.newStub(this.channel);
    }

    private void initElectionId() {
        ElectionIdGenerator generator = ElectionIdGenerator.getInstance();
        generator.addObserver(this);
        this.electionId = generator.getElectionId();
    }

    public void notifyWhenStateChanged(ConnectivityState source, Runnable callback) {
        this.channel.notifyWhenStateChanged(source, callback);
    }

    public boolean getConnectState() {
        return this.channel.getState(true) == ConnectivityState.READY && this.requestStreamObserver != null;
    }

    public void shutdown() {
        ElectionIdGenerator.getInstance().deleteObserver(this);
        this.channel.shutdown();
    }

    public SetForwardingPipelineConfigResponse setPipelineConfig(SetForwardingPipelineConfigRequest request) {
        try {
            SetForwardingPipelineConfigResponse response = this.blockingStub.setForwardingPipelineConfig(request);
            return response;
        }
        catch (StatusRuntimeException e) {
            LOG.info(String.format("Set pipeline config exception, Status = %s, Reason = %s", e.getStatus(), e.getMessage()));
            throw new RuntimeException(e);
        }
    }

    public GetForwardingPipelineConfigResponse getPipelineConfig(GetForwardingPipelineConfigRequest request) {
        try {
            GetForwardingPipelineConfigResponse response = this.blockingStub.getForwardingPipelineConfig(request);
            return response;
        }
        catch (StatusRuntimeException e) {
            LOG.info(String.format("Get pipeline config exception, Status = %s, Reason = %s", e.getStatus(), e.getMessage()));
            throw new RuntimeException(e);
        }
    }

    public void streamChannel() {
        StreamObserver<StreamMessageResponse> responseStreamObserver = new StreamObserver<StreamMessageResponse>(){

            @Override
            public void onNext(StreamMessageResponse value) {
                RuntimeStub.this.onPacketReceived(value);
            }

            @Override
            public void onError(Throwable t) {
                RuntimeStub.this.onStreamChannelError(t);
            }

            @Override
            public void onCompleted() {
                RuntimeStub.this.onStreamChannelComplete();
            }
        };
        this.requestStreamObserver = this.asyncStub.streamChannel(responseStreamObserver);
        this.sendMasterArbitration(this.electionId);
        this.awaitConnection(5000L);
    }

    public void transmitPacket(byte[] payload) {
        StreamMessageRequest.Builder requestBuilder = StreamMessageRequest.newBuilder();
        PacketOut.Builder packetOutBuilder = PacketOut.newBuilder();
        packetOutBuilder.setPayload(ByteString.copyFrom(payload));
        requestBuilder.setPacket(packetOutBuilder);
        if (this.requestStreamObserver != null) {
            this.requestStreamObserver.onNext(requestBuilder.build());
            LOG.info("Transmit packet = {} to device = {}.", (Object)Utils.bytesToHexString(payload), (Object)this.nodeId);
        } else {
            LOG.info("Stream channel haven't been initialized, device = [{}].", (Object)this.nodeId);
        }
    }

    public WriteResponse write(WriteRequest request) {
        try {
            WriteResponse response = this.blockingStub.write(request);
            return response;
        }
        catch (StatusRuntimeException e) {
            LOG.info(String.format("Write RPC exception, Status = %s, Reason = %s", e.getStatus(), e.getMessage()));
            throw new RuntimeException(e);
        }
    }

    public Iterator<ReadResponse> read(ReadRequest request) {
        try {
            Iterator<ReadResponse> responses = this.blockingStub.read(request);
            return responses;
        }
        catch (StatusRuntimeException e) {
            LOG.info(String.format("Read RPC exception, Status = %s, Reason = %s", e.getStatus(), e.getMessage()));
            throw new RuntimeException(e);
        }
    }

    public void sendMasterArbitration(ElectionId electionId) {
        StreamMessageRequest.Builder requestBuilder = StreamMessageRequest.newBuilder();
        MasterArbitrationUpdate.Builder masterArbitrationBuilder = MasterArbitrationUpdate.newBuilder();
        Uint128.Builder electionIdBuilder = Uint128.newBuilder();
        electionIdBuilder.setHigh(electionId.getHigh());
        electionIdBuilder.setLow(electionId.getLow());
        masterArbitrationBuilder.setDeviceId(this.deviceId);
        masterArbitrationBuilder.setElectionId(electionIdBuilder);
        requestBuilder.setArbitration(masterArbitrationBuilder);
        if (this.requestStreamObserver != null) {
            this.requestStreamObserver.onNext(requestBuilder.build());
            LOG.info("Send MasterArbitrationUpdate to device = {}.", (Object)this.nodeId);
        } else {
            LOG.info("Stream channel haven't been initialized, device = [{}].", (Object)this.nodeId);
        }
    }

    private void onPacketReceived(StreamMessageResponse response) {
        switch (response.getUpdateCase()) {
            case PACKET: {
                P4PacketReceivedBuilder builder = new P4PacketReceivedBuilder();
                byte[] payload = response.getPacket().getPayload().toByteArray();
                builder.setNid(this.nodeId);
                builder.setPayload(payload);
                NotificationPublisher.getInstance().notify(builder.build());
                LOG.info("Receive packet from node = {}, body = {}.", (Object)this.nodeId, (Object)Utils.bytesToHexString(payload));
                break;
            }
            case ARBITRATION: {
                break;
            }
            case UPDATE_NOT_SET: {
                break;
            }
        }
    }

    private void onStreamChannelError(Throwable t) {
        this.requestStreamObserver = null;
        LOG.info("Stream channel on error, reason = {}, node = {}.", (Object)t.getMessage(), (Object)this.nodeId);
    }

    private void onStreamChannelComplete() {
        this.requestStreamObserver = null;
        LOG.info("Stream channel on complete, node = {}.", (Object)this.nodeId);
    }

    @Override
    public void update(ElectionId electionId) {
        this.electionId = electionId;
        this.sendMasterArbitration(electionId);
    }

    public ElectionId getElectionId() {
        return this.electionId;
    }

    private void awaitConnection(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

