/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.p4plugin.runtime.impl.utils;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import org.opendaylight.p4plugin.p4info.proto.P4Info;

public abstract class Utils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static P4Info parseRuntimeInfo(String file) throws IOException {
        if (file != null) {
            P4Info.Builder info = P4Info.newBuilder();
            try (FileReader reader = null;){
                reader = new FileReader(file);
                TextFormat.merge(reader, (Message.Builder)info);
                P4Info p4Info = info.build();
                return p4Info;
            }
        }
        return null;
    }

    public static ByteString parseDeviceConfigInfo(String file) throws IOException {
        if (file != null) {
            FileInputStream input = new FileInputStream(new File(file));
            return ByteString.readFrom(input);
        }
        return null;
    }

    public static byte[] strToByteArray(String str, int len) {
        String[] strArray = null;
        byte[] byteArray = null;
        if (str.matches("([1-9]|[1-9]\\d|1\\d{2}|2[0-4]|25[0-5])\\.((\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])\\.){2}(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])")) {
            strArray = str.split("\\.");
            byteArray = new byte[strArray.length];
            assert (len == strArray.length);
            for (int i = 0; i < strArray.length; ++i) {
                byteArray[i] = (byte)Integer.parseInt(strArray[i]);
            }
        } else if (str.matches("([0-9a-fA-F]{1,2}:){5}[0-9a-fA-F]{1,2}")) {
            strArray = str.split(":");
            byteArray = new byte[strArray.length];
            assert (len == strArray.length);
            for (int i = 0; i < strArray.length; ++i) {
                byteArray[i] = (byte)Integer.parseInt(strArray[i], 16);
            }
        } else {
            int value = Integer.parseInt(str);
            byteArray = new byte[len];
            for (int i = 0; i < len; ++i) {
                byteArray[i] = (byte)(value >> (len - i - 1) * 8 & 0xFF);
            }
        }
        return byteArray;
    }

    public static String byteArrayToStr(byte[] input) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < input.length; ++i) {
            buffer.append(String.valueOf(input[i]));
            buffer.append(" ");
        }
        return new String(buffer);
    }

    public static byte[] intToByteArray(int integer) {
        int byteNum = (40 - Integer.numberOfLeadingZeros(integer < 0 ? ~integer : integer)) / 8;
        byte[] byteArray = new byte[4];
        for (int n = 0; n < byteNum; ++n) {
            byteArray[3 - n] = (byte)(integer >>> n * 8);
        }
        return byteArray;
    }

    public static int byteArrayToInt(byte[] b, int offset) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (b[i + offset] & 0xFF) << shift;
        }
        return value;
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }
}

