/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.qos.msg.rev151006.nodes.node.list.port.list;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.Duration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.NodeConnectorStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.node.connector.statistics.Bytes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.node.connector.statistics.Packets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.qos.msg.rev151006.nodes.node.list.port.list.PortParams;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PortParamsBuilder
implements Builder<PortParams> {
    private Bytes _bytes;
    private BigInteger _collisionCount;
    private org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.duration.Duration _duration;
    private Packets _packets;
    private String _portName;
    private BigInteger _receiveCrcError;
    private BigInteger _receiveDrops;
    private BigInteger _receiveErrors;
    private BigInteger _receiveFrameError;
    private BigInteger _receiveOverRunError;
    private BigInteger _transmitDrops;
    private BigInteger _transmitErrors;
    Map<Class<? extends Augmentation<PortParams>>, Augmentation<PortParams>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKCOLLISIONCOUNTRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKRECEIVECRCERRORRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKRECEIVEDROPSRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKRECEIVEERRORSRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKRECEIVEFRAMEERRORRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKRECEIVEOVERRUNERRORRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKTRANSMITDROPSRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKTRANSMITERRORSRANGE_RANGES;

    public PortParamsBuilder() {
    }

    public PortParamsBuilder(NodeConnectorStatistics arg) {
        this._packets = arg.getPackets();
        this._bytes = arg.getBytes();
        this._receiveDrops = arg.getReceiveDrops();
        this._transmitDrops = arg.getTransmitDrops();
        this._receiveErrors = arg.getReceiveErrors();
        this._transmitErrors = arg.getTransmitErrors();
        this._receiveFrameError = arg.getReceiveFrameError();
        this._receiveOverRunError = arg.getReceiveOverRunError();
        this._receiveCrcError = arg.getReceiveCrcError();
        this._collisionCount = arg.getCollisionCount();
        this._duration = arg.getDuration();
    }

    public PortParamsBuilder(Duration arg) {
        this._duration = arg.getDuration();
    }

    public PortParamsBuilder(PortParams base) {
        AugmentationHolder casted;
        this._bytes = base.getBytes();
        this._collisionCount = base.getCollisionCount();
        this._duration = base.getDuration();
        this._packets = base.getPackets();
        this._portName = base.getPortName();
        this._receiveCrcError = base.getReceiveCrcError();
        this._receiveDrops = base.getReceiveDrops();
        this._receiveErrors = base.getReceiveErrors();
        this._receiveFrameError = base.getReceiveFrameError();
        this._receiveOverRunError = base.getReceiveOverRunError();
        this._transmitDrops = base.getTransmitDrops();
        this._transmitErrors = base.getTransmitErrors();
        if (base instanceof PortParamsImpl) {
            PortParamsImpl impl = (PortParamsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PortParams>>, Augmentation<PortParams>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PortParams>>, Augmentation<PortParams>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NodeConnectorStatistics) {
            this._packets = ((NodeConnectorStatistics)arg).getPackets();
            this._bytes = ((NodeConnectorStatistics)arg).getBytes();
            this._receiveDrops = ((NodeConnectorStatistics)arg).getReceiveDrops();
            this._transmitDrops = ((NodeConnectorStatistics)arg).getTransmitDrops();
            this._receiveErrors = ((NodeConnectorStatistics)arg).getReceiveErrors();
            this._transmitErrors = ((NodeConnectorStatistics)arg).getTransmitErrors();
            this._receiveFrameError = ((NodeConnectorStatistics)arg).getReceiveFrameError();
            this._receiveOverRunError = ((NodeConnectorStatistics)arg).getReceiveOverRunError();
            this._receiveCrcError = ((NodeConnectorStatistics)arg).getReceiveCrcError();
            this._collisionCount = ((NodeConnectorStatistics)arg).getCollisionCount();
            isValidArg = true;
        }
        if (arg instanceof Duration) {
            this._duration = ((Duration)arg).getDuration();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.NodeConnectorStatistics, org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.Duration] \nbut was: " + arg);
        }
    }

    public Bytes getBytes() {
        return this._bytes;
    }

    public BigInteger getCollisionCount() {
        return this._collisionCount;
    }

    public org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.duration.Duration getDuration() {
        return this._duration;
    }

    public Packets getPackets() {
        return this._packets;
    }

    public String getPortName() {
        return this._portName;
    }

    public BigInteger getReceiveCrcError() {
        return this._receiveCrcError;
    }

    public BigInteger getReceiveDrops() {
        return this._receiveDrops;
    }

    public BigInteger getReceiveErrors() {
        return this._receiveErrors;
    }

    public BigInteger getReceiveFrameError() {
        return this._receiveFrameError;
    }

    public BigInteger getReceiveOverRunError() {
        return this._receiveOverRunError;
    }

    public BigInteger getTransmitDrops() {
        return this._transmitDrops;
    }

    public BigInteger getTransmitErrors() {
        return this._transmitErrors;
    }

    public <E extends Augmentation<PortParams>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PortParamsBuilder setBytes(Bytes value) {
        this._bytes = value;
        return this;
    }

    private static void checkCollisionCountRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKCOLLISIONCOUNTRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKCOLLISIONCOUNTRANGE_RANGES)));
    }

    public PortParamsBuilder setCollisionCount(BigInteger value) {
        if (value != null) {
            PortParamsBuilder.checkCollisionCountRange(value);
        }
        this._collisionCount = value;
        return this;
    }

    public PortParamsBuilder setDuration(org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.duration.Duration value) {
        this._duration = value;
        return this;
    }

    public PortParamsBuilder setPackets(Packets value) {
        this._packets = value;
        return this;
    }

    public PortParamsBuilder setPortName(String value) {
        this._portName = value;
        return this;
    }

    private static void checkReceiveCrcErrorRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKRECEIVECRCERRORRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKRECEIVECRCERRORRANGE_RANGES)));
    }

    public PortParamsBuilder setReceiveCrcError(BigInteger value) {
        if (value != null) {
            PortParamsBuilder.checkReceiveCrcErrorRange(value);
        }
        this._receiveCrcError = value;
        return this;
    }

    private static void checkReceiveDropsRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKRECEIVEDROPSRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKRECEIVEDROPSRANGE_RANGES)));
    }

    public PortParamsBuilder setReceiveDrops(BigInteger value) {
        if (value != null) {
            PortParamsBuilder.checkReceiveDropsRange(value);
        }
        this._receiveDrops = value;
        return this;
    }

    private static void checkReceiveErrorsRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKRECEIVEERRORSRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKRECEIVEERRORSRANGE_RANGES)));
    }

    public PortParamsBuilder setReceiveErrors(BigInteger value) {
        if (value != null) {
            PortParamsBuilder.checkReceiveErrorsRange(value);
        }
        this._receiveErrors = value;
        return this;
    }

    private static void checkReceiveFrameErrorRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKRECEIVEFRAMEERRORRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKRECEIVEFRAMEERRORRANGE_RANGES)));
    }

    public PortParamsBuilder setReceiveFrameError(BigInteger value) {
        if (value != null) {
            PortParamsBuilder.checkReceiveFrameErrorRange(value);
        }
        this._receiveFrameError = value;
        return this;
    }

    private static void checkReceiveOverRunErrorRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKRECEIVEOVERRUNERRORRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKRECEIVEOVERRUNERRORRANGE_RANGES)));
    }

    public PortParamsBuilder setReceiveOverRunError(BigInteger value) {
        if (value != null) {
            PortParamsBuilder.checkReceiveOverRunErrorRange(value);
        }
        this._receiveOverRunError = value;
        return this;
    }

    private static void checkTransmitDropsRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKTRANSMITDROPSRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKTRANSMITDROPSRANGE_RANGES)));
    }

    public PortParamsBuilder setTransmitDrops(BigInteger value) {
        if (value != null) {
            PortParamsBuilder.checkTransmitDropsRange(value);
        }
        this._transmitDrops = value;
        return this;
    }

    private static void checkTransmitErrorsRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKTRANSMITERRORSRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKTRANSMITERRORSRANGE_RANGES)));
    }

    public PortParamsBuilder setTransmitErrors(BigInteger value) {
        if (value != null) {
            PortParamsBuilder.checkTransmitErrorsRange(value);
        }
        this._transmitErrors = value;
        return this;
    }

    public PortParamsBuilder addAugmentation(Class<? extends Augmentation<PortParams>> augmentationType, Augmentation<PortParams> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PortParams>>, Augmentation<PortParams>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PortParamsBuilder removeAugmentation(Class<? extends Augmentation<PortParams>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PortParams build() {
        return new PortParamsImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKCOLLISIONCOUNTRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKRECEIVECRCERRORRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKRECEIVEDROPSRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKRECEIVEERRORSRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKRECEIVEFRAMEERRORRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKRECEIVEOVERRUNERRORRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKTRANSMITDROPSRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKTRANSMITERRORSRANGE_RANGES = a;
    }

    private static final class PortParamsImpl
    implements PortParams {
        private final Bytes _bytes;
        private final BigInteger _collisionCount;
        private final org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.duration.Duration _duration;
        private final Packets _packets;
        private final String _portName;
        private final BigInteger _receiveCrcError;
        private final BigInteger _receiveDrops;
        private final BigInteger _receiveErrors;
        private final BigInteger _receiveFrameError;
        private final BigInteger _receiveOverRunError;
        private final BigInteger _transmitDrops;
        private final BigInteger _transmitErrors;
        private Map<Class<? extends Augmentation<PortParams>>, Augmentation<PortParams>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PortParams> getImplementedInterface() {
            return PortParams.class;
        }

        private PortParamsImpl(PortParamsBuilder base) {
            this._bytes = base.getBytes();
            this._collisionCount = base.getCollisionCount();
            this._duration = base.getDuration();
            this._packets = base.getPackets();
            this._portName = base.getPortName();
            this._receiveCrcError = base.getReceiveCrcError();
            this._receiveDrops = base.getReceiveDrops();
            this._receiveErrors = base.getReceiveErrors();
            this._receiveFrameError = base.getReceiveFrameError();
            this._receiveOverRunError = base.getReceiveOverRunError();
            this._transmitDrops = base.getTransmitDrops();
            this._transmitErrors = base.getTransmitErrors();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PortParams>>, Augmentation<PortParams>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PortParams>>, Augmentation<PortParams>>(base.augmentation);
                }
            }
        }

        public Bytes getBytes() {
            return this._bytes;
        }

        public BigInteger getCollisionCount() {
            return this._collisionCount;
        }

        public org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.duration.Duration getDuration() {
            return this._duration;
        }

        public Packets getPackets() {
            return this._packets;
        }

        @Override
        public String getPortName() {
            return this._portName;
        }

        public BigInteger getReceiveCrcError() {
            return this._receiveCrcError;
        }

        public BigInteger getReceiveDrops() {
            return this._receiveDrops;
        }

        public BigInteger getReceiveErrors() {
            return this._receiveErrors;
        }

        public BigInteger getReceiveFrameError() {
            return this._receiveFrameError;
        }

        public BigInteger getReceiveOverRunError() {
            return this._receiveOverRunError;
        }

        public BigInteger getTransmitDrops() {
            return this._transmitDrops;
        }

        public BigInteger getTransmitErrors() {
            return this._transmitErrors;
        }

        public <E extends Augmentation<PortParams>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bytes);
            result = 31 * result + Objects.hashCode(this._collisionCount);
            result = 31 * result + Objects.hashCode(this._duration);
            result = 31 * result + Objects.hashCode(this._packets);
            result = 31 * result + Objects.hashCode(this._portName);
            result = 31 * result + Objects.hashCode(this._receiveCrcError);
            result = 31 * result + Objects.hashCode(this._receiveDrops);
            result = 31 * result + Objects.hashCode(this._receiveErrors);
            result = 31 * result + Objects.hashCode(this._receiveFrameError);
            result = 31 * result + Objects.hashCode(this._receiveOverRunError);
            result = 31 * result + Objects.hashCode(this._transmitDrops);
            result = 31 * result + Objects.hashCode(this._transmitErrors);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PortParams.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PortParams other = (PortParams)obj;
            if (!Objects.equals(this._bytes, other.getBytes())) {
                return false;
            }
            if (!Objects.equals(this._collisionCount, other.getCollisionCount())) {
                return false;
            }
            if (!Objects.equals(this._duration, other.getDuration())) {
                return false;
            }
            if (!Objects.equals(this._packets, other.getPackets())) {
                return false;
            }
            if (!Objects.equals(this._portName, other.getPortName())) {
                return false;
            }
            if (!Objects.equals(this._receiveCrcError, other.getReceiveCrcError())) {
                return false;
            }
            if (!Objects.equals(this._receiveDrops, other.getReceiveDrops())) {
                return false;
            }
            if (!Objects.equals(this._receiveErrors, other.getReceiveErrors())) {
                return false;
            }
            if (!Objects.equals(this._receiveFrameError, other.getReceiveFrameError())) {
                return false;
            }
            if (!Objects.equals(this._receiveOverRunError, other.getReceiveOverRunError())) {
                return false;
            }
            if (!Objects.equals(this._transmitDrops, other.getTransmitDrops())) {
                return false;
            }
            if (!Objects.equals(this._transmitErrors, other.getTransmitErrors())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PortParamsImpl otherImpl = (PortParamsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PortParams>>, Augmentation<PortParams>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "PortParams [";
            StringBuilder builder = new StringBuilder(name);
            if (this._bytes != null) {
                builder.append("_bytes=");
                builder.append(this._bytes);
                builder.append(", ");
            }
            if (this._collisionCount != null) {
                builder.append("_collisionCount=");
                builder.append(this._collisionCount);
                builder.append(", ");
            }
            if (this._duration != null) {
                builder.append("_duration=");
                builder.append(this._duration);
                builder.append(", ");
            }
            if (this._packets != null) {
                builder.append("_packets=");
                builder.append(this._packets);
                builder.append(", ");
            }
            if (this._portName != null) {
                builder.append("_portName=");
                builder.append(this._portName);
                builder.append(", ");
            }
            if (this._receiveCrcError != null) {
                builder.append("_receiveCrcError=");
                builder.append(this._receiveCrcError);
                builder.append(", ");
            }
            if (this._receiveDrops != null) {
                builder.append("_receiveDrops=");
                builder.append(this._receiveDrops);
                builder.append(", ");
            }
            if (this._receiveErrors != null) {
                builder.append("_receiveErrors=");
                builder.append(this._receiveErrors);
                builder.append(", ");
            }
            if (this._receiveFrameError != null) {
                builder.append("_receiveFrameError=");
                builder.append(this._receiveFrameError);
                builder.append(", ");
            }
            if (this._receiveOverRunError != null) {
                builder.append("_receiveOverRunError=");
                builder.append(this._receiveOverRunError);
                builder.append(", ");
            }
            if (this._transmitDrops != null) {
                builder.append("_transmitDrops=");
                builder.append(this._transmitDrops);
                builder.append(", ");
            }
            if (this._transmitErrors != null) {
                builder.append("_transmitErrors=");
                builder.append(this._transmitErrors);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

