/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.qos.msg.rev151006.nodes;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.qos.msg.rev151006.nodes.NodeList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.qos.msg.rev151006.nodes.NodeListKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.qos.msg.rev151006.nodes.node.list.PortList;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NodeListBuilder
implements Builder<NodeList> {
    private NodeListKey _key;
    private String _nodeId;
    private List<PortList> _portList;
    Map<Class<? extends Augmentation<NodeList>>, Augmentation<NodeList>> augmentation = Collections.emptyMap();

    public NodeListBuilder() {
    }

    public NodeListBuilder(NodeList base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new NodeListKey(base.getNodeId());
            this._nodeId = base.getNodeId();
        } else {
            this._key = base.getKey();
            this._nodeId = this._key.getNodeId();
        }
        this._portList = base.getPortList();
        if (base instanceof NodeListImpl) {
            NodeListImpl impl = (NodeListImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NodeList>>, Augmentation<NodeList>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NodeList>>, Augmentation<NodeList>>(casted.augmentations());
        }
    }

    public NodeListKey getKey() {
        return this._key;
    }

    public String getNodeId() {
        return this._nodeId;
    }

    public List<PortList> getPortList() {
        return this._portList;
    }

    public <E extends Augmentation<NodeList>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NodeListBuilder setKey(NodeListKey value) {
        this._key = value;
        return this;
    }

    public NodeListBuilder setNodeId(String value) {
        this._nodeId = value;
        return this;
    }

    public NodeListBuilder setPortList(List<PortList> value) {
        this._portList = value;
        return this;
    }

    public NodeListBuilder addAugmentation(Class<? extends Augmentation<NodeList>> augmentationType, Augmentation<NodeList> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NodeList>>, Augmentation<NodeList>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NodeListBuilder removeAugmentation(Class<? extends Augmentation<NodeList>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NodeList build() {
        return new NodeListImpl(this);
    }

    private static final class NodeListImpl
    implements NodeList {
        private final NodeListKey _key;
        private final String _nodeId;
        private final List<PortList> _portList;
        private Map<Class<? extends Augmentation<NodeList>>, Augmentation<NodeList>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NodeList> getImplementedInterface() {
            return NodeList.class;
        }

        private NodeListImpl(NodeListBuilder base) {
            if (base.getKey() == null) {
                this._key = new NodeListKey(base.getNodeId());
                this._nodeId = base.getNodeId();
            } else {
                this._key = base.getKey();
                this._nodeId = this._key.getNodeId();
            }
            this._portList = base.getPortList();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NodeList>>, Augmentation<NodeList>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NodeList>>, Augmentation<NodeList>>(base.augmentation);
                }
            }
        }

        @Override
        public NodeListKey getKey() {
            return this._key;
        }

        @Override
        public String getNodeId() {
            return this._nodeId;
        }

        @Override
        public List<PortList> getPortList() {
            return this._portList;
        }

        public <E extends Augmentation<NodeList>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._nodeId);
            result = 31 * result + Objects.hashCode(this._portList);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NodeList.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NodeList other = (NodeList)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._nodeId, other.getNodeId())) {
                return false;
            }
            if (!Objects.equals(this._portList, other.getPortList())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NodeListImpl otherImpl = (NodeListImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NodeList>>, Augmentation<NodeList>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "NodeList [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._nodeId != null) {
                builder.append("_nodeId=");
                builder.append(this._nodeId);
                builder.append(", ");
            }
            if (this._portList != null) {
                builder.append("_portList=");
                builder.append(this._portList);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

