package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.impl.rev151006.modules.module.configuration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.impl.rev151006.modules.module.configuration.sdninterfaceapp.RpcRegistry;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.impl.rev151006.modules.module.configuration.sdninterfaceapp.Broker;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules.module.Configuration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.impl.rev151006.modules.module.configuration.sdninterfaceapp.DataBroker;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>sdninterfaceapp-impl</b>
 * <pre>
 * case sdninterfaceapp {
 *     container broker {
 *         leaf type {
 *             type leafref;
 *         }
 *         leaf name {
 *             type leafref;
 *         }
 *         uses service-ref {
 *             refine (urn:opendaylight:params:xml:ns:yang:sdninterfaceapp:impl?revision=2015-10-06)type {
 *                 leaf type {
 *                     type leafref;
 *                 }
 *             }
 *         }
 *     }
 *     container data-broker {
 *         leaf type {
 *             type leafref;
 *         }
 *         leaf name {
 *             type leafref;
 *         }
 *         uses service-ref {
 *             refine (urn:opendaylight:params:xml:ns:yang:sdninterfaceapp:impl?revision=2015-10-06)type {
 *                 leaf type {
 *                     type leafref;
 *                 }
 *             }
 *         }
 *     }
 *     container rpc-registry {
 *         leaf type {
 *             type leafref;
 *         }
 *         leaf name {
 *             type leafref;
 *         }
 *         uses service-ref {
 *             refine (urn:opendaylight:params:xml:ns:yang:sdninterfaceapp:impl?revision=2015-10-06)type {
 *                 leaf type {
 *                     type leafref;
 *                 }
 *             }
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>sdninterfaceapp-impl/modules/module/configuration/(urn:opendaylight:params:xml:ns:yang:sdninterfaceapp:impl?revision=2015-10-06)sdninterfaceapp</i>
 *
 */
public interface Sdninterfaceapp
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.impl.rev151006.modules.module.configuration.Sdninterfaceapp>,
    Configuration
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:sdninterfaceapp:impl",
        "2015-10-06", "sdninterfaceapp").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.impl.rev151006.modules.module.configuration.sdninterfaceapp.Broker</code> <code>broker</code>, or <code>null</code> if not present
     */
    Broker getBroker();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.impl.rev151006.modules.module.configuration.sdninterfaceapp.DataBroker</code> <code>dataBroker</code>, or <code>null</code> if not present
     */
    DataBroker getDataBroker();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.impl.rev151006.modules.module.configuration.sdninterfaceapp.RpcRegistry</code> <code>rpcRegistry</code>, or <code>null</code> if not present
     */
    RpcRegistry getRpcRegistry();

}

