package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.sdniwrapper.rev151007.modules.module.configuration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.sdniwrapper.rev151007.modules.module.configuration.sdniwrapper.RpcRegistry;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.sdniwrapper.rev151007.modules.module.configuration.sdniwrapper.Broker;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules.module.Configuration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.sdniwrapper.rev151007.modules.module.configuration.sdniwrapper.NotificationService;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>sdniwrapper</b>
 * <pre>
 * case sdniwrapper {
 *     container broker {
 *         leaf type {
 *             type leafref;
 *         }
 *         leaf name {
 *             type leafref;
 *         }
 *         uses service-ref {
 *             refine (urn:opendaylight:params:xml:ns:yang:sdninterfaceapp:sdniwrapper?revision=2015-10-07)type {
 *                 leaf type {
 *                     type leafref;
 *                 }
 *             }
 *         }
 *     }
 *     container notification-service {
 *         leaf type {
 *             type leafref;
 *         }
 *         leaf name {
 *             type leafref;
 *         }
 *         uses service-ref {
 *             refine (urn:opendaylight:params:xml:ns:yang:sdninterfaceapp:sdniwrapper?revision=2015-10-07)type {
 *                 leaf type {
 *                     type leafref;
 *                 }
 *             }
 *         }
 *     }
 *     container rpc-registry {
 *         leaf type {
 *             type leafref;
 *         }
 *         leaf name {
 *             type leafref;
 *         }
 *         uses service-ref {
 *             refine (urn:opendaylight:params:xml:ns:yang:sdninterfaceapp:sdniwrapper?revision=2015-10-07)type {
 *                 leaf type {
 *                     type leafref;
 *                 }
 *             }
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>sdniwrapper/modules/module/configuration/(urn:opendaylight:params:xml:ns:yang:sdninterfaceapp:sdniwrapper?revision=2015-10-07)sdniwrapper</i>
 *
 */
public interface Sdniwrapper
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.sdniwrapper.rev151007.modules.module.configuration.Sdniwrapper>,
    Configuration
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:sdninterfaceapp:sdniwrapper",
        "2015-10-07", "sdniwrapper").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.sdniwrapper.rev151007.modules.module.configuration.sdniwrapper.Broker</code> <code>broker</code>, or <code>null</code> if not present
     */
    Broker getBroker();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.sdniwrapper.rev151007.modules.module.configuration.sdniwrapper.NotificationService</code> <code>notificationService</code>, or <code>null</code> if not present
     */
    NotificationService getNotificationService();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.sdniwrapper.rev151007.modules.module.configuration.sdniwrapper.RpcRegistry</code> <code>rpcRegistry</code>, or <code>null</code> if not present
     */
    RpcRegistry getRpcRegistry();

}

