/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.serviceutils.srm.shell;

import com.google.common.util.concurrent.ListenableFuture;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.serviceutils.srm.shell.SrmCliUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.rpc.rev180626.OdlSrmRpcsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.rpc.rev180626.RecoverInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.rpc.rev180626.RecoverInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.rpc.rev180626.RecoverOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.EntityNameBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.EntityTypeBase;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="srm", name="recover", description="Recover service or instance")
public class RecoverCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(RecoverCommand.class);
    @Argument(index=0, name="type", description="EntityType, required", required=false, multiValued=false)
    String type;
    @Argument(index=1, name="name", description="EntityName, required", required=false, multiValued=false)
    String name;
    @Argument(index=2, name="id", description="EntityId, optional", required=false, multiValued=false)
    String id;
    private final OdlSrmRpcsService srmRpcService;

    public RecoverCommand(OdlSrmRpcsService srmRpcService) {
        this.srmRpcService = srmRpcService;
    }

    @Deprecated
    protected @Nullable Object doExecute() throws Exception {
        RecoverInput input = this.getInput();
        if (input == null) {
            return null;
        }
        ListenableFuture result = this.srmRpcService.recover(input);
        RpcResult recoverResult = (RpcResult)result.get();
        this.printResult((RpcResult<RecoverOutput>)recoverResult);
        return null;
    }

    private void printResult(RpcResult<RecoverOutput> recoverResult) {
        StringBuilder strResult = new StringBuilder("");
        if (recoverResult.isSuccessful()) {
            strResult.append("RPC call to recover was successful");
            LOG.trace("RPC Result: {}", recoverResult.getResult());
        } else {
            strResult.append("RPC Call to recover failed.\n").append("ErrorCode: ").append(((RecoverOutput)recoverResult.getResult()).getResponse()).append("ErrorMsg: ").append(((RecoverOutput)recoverResult.getResult()).getMessage());
            LOG.trace("RPC Result: {}", recoverResult.getResult());
        }
        this.session.getConsole().println(strResult.toString());
    }

    private @Nullable RecoverInput getInput() {
        if (this.type == null || this.name == null) {
            return null;
        }
        EntityTypeBase entityType = SrmCliUtils.getEntityType(this.type);
        if (entityType == null) {
            this.session.getConsole().println(SrmCliUtils.getTypeHelp());
            return null;
        }
        EntityNameBase entityName = SrmCliUtils.getEntityName(entityType, this.name);
        if (entityName == null) {
            this.session.getConsole().println(SrmCliUtils.getNameHelp(entityType));
            return null;
        }
        RecoverInputBuilder inputBuilder = new RecoverInputBuilder();
        inputBuilder.setEntityType(entityType);
        inputBuilder.setEntityName(entityName);
        if (this.id != null) {
            inputBuilder.setEntityId(this.id);
        }
        return inputBuilder.build();
    }
}

