/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.serviceutils.srm.shell;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.EntityNameBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.EntityTypeBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.EntityTypeInstance;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.EntityTypeService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.GeniusIfm;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.GeniusIfmInterface;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.GeniusItm;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.GeniusItmTep;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.GeniusItmTz;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtAcl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtAclInstance;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtAclInterface;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtDhcp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtElan;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtElanInterface;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtL2gw;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtL2gwConnection;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtL2gwNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtQos;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtQosPolicyInstance;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtVpn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtVpnInstance;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.Ofplugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SrmCliUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SrmCliUtils.class);
    private static final ImmutableMap<String, EntityTypeBase> ENTITY_TYPE_MAP = ImmutableMap.builder().put((Object)"SERVICE", (Object)EntityTypeService.VALUE).put((Object)"INSTANCE", (Object)EntityTypeInstance.VALUE).build();
    private static final ImmutableMap<String, EntityNameBase> SERVICE_NAME_MAP = ImmutableMap.builder().put((Object)"ITM", (Object)GeniusItm.VALUE).put((Object)"IFM", (Object)GeniusIfm.VALUE).put((Object)"VPN", (Object)NetvirtVpn.VALUE).put((Object)"ELAN", (Object)NetvirtElan.VALUE).put((Object)"DHCP", (Object)NetvirtDhcp.VALUE).put((Object)"L2GW", (Object)NetvirtL2gw.VALUE).put((Object)"ACL", (Object)NetvirtAcl.VALUE).put((Object)"OFPLUGIN", (Object)Ofplugin.VALUE).put((Object)"QOS", (Object)NetvirtQos.VALUE).build();
    private static final ImmutableMap<String, EntityNameBase> INSTANCE_NAME_MAP = ImmutableMap.builder().put((Object)"ITM-TEP", (Object)GeniusItmTep.VALUE).put((Object)"ITM-TZ", (Object)GeniusItmTz.VALUE).put((Object)"IFM-IFACE", (Object)GeniusIfmInterface.VALUE).put((Object)"VPN-INSTANCE", (Object)NetvirtVpnInstance.VALUE).put((Object)"ELAN-INTERFACE", (Object)NetvirtElanInterface.VALUE).put((Object)"L2GW-NODE", (Object)NetvirtL2gwNode.VALUE).put((Object)"L2GW-CONNECTION", (Object)NetvirtL2gwConnection.VALUE).put((Object)"QOS-POLICY-INSTANCE", (Object)NetvirtQosPolicyInstance.VALUE).put((Object)"ACL-INTERFACE", (Object)NetvirtAclInterface.VALUE).put((Object)"ACL-INSTANCE", (Object)NetvirtAclInstance.VALUE).build();

    private SrmCliUtils() {
    }

    public static EntityTypeBase getEntityType(String strType) {
        LOG.debug("Getting entityType for type {}", (Object)strType);
        return (EntityTypeBase)ENTITY_TYPE_MAP.get((Object)strType.toUpperCase(Locale.ROOT));
    }

    public static @Nullable EntityNameBase getEntityName(EntityTypeBase type, String strName) {
        LOG.debug("Getting entityName for type {} and name: {}", (Object)type, (Object)strName);
        if (EntityTypeService.VALUE.equals(type)) {
            return (EntityNameBase)SERVICE_NAME_MAP.get((Object)strName.toUpperCase(Locale.ROOT));
        }
        if (EntityTypeInstance.VALUE.equals(type)) {
            return (EntityNameBase)INSTANCE_NAME_MAP.get((Object)strName.toUpperCase(Locale.ROOT));
        }
        return null;
    }

    public static String getTypeHelp() {
        StringBuilder help = new StringBuilder("Supported Entity Types are:\n");
        for (String entityType : ENTITY_TYPE_MAP.keySet()) {
            help.append("\t").append(entityType).append("/").append(entityType.toLowerCase(Locale.ROOT)).append("\n");
        }
        return help.toString();
    }

    public static String getNameHelp(EntityTypeBase entityType) {
        StringBuilder help;
        block3: {
            block2: {
                help = new StringBuilder("Supported Entity Names for type");
                if (!EntityTypeService.VALUE.equals(entityType)) break block2;
                help.append(" SERVICE are:\n");
                for (String entityName : SERVICE_NAME_MAP.keySet()) {
                    help.append(String.format("\t%s/%s%n", entityName.toLowerCase(Locale.ROOT), entityName));
                }
                break block3;
            }
            if (!EntityTypeInstance.VALUE.equals(entityType)) break block3;
            help.append(" INSTANCE are:\n");
            for (String entityName : INSTANCE_NAME_MAP.keySet()) {
                help.append(String.format("\t%s/%s%n", entityName.toLowerCase(Locale.ROOT), entityName));
            }
        }
        return help.toString();
    }
}

