/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.sfc.pot.netconf.renderer.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.serviceutils.tools.mdsal.listener.AbstractSyncDataTreeChangeListener;
import org.opendaylight.sfc.pot.netconf.renderer.provider.SfcPotNetconfNodeManager;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.status.AvailableCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.status.available.capabilities.AvailableCapability;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SfcPotNetconfNodeListener
extends AbstractSyncDataTreeChangeListener<Node> {
    private static final Logger LOG = LoggerFactory.getLogger(SfcPotNetconfNodeListener.class);
    private final SfcPotNetconfNodeManager nodeManager;
    private List<String> ioamNetconfCapabilities = new ArrayList<String>();

    @Inject
    public SfcPotNetconfNodeListener(DataBroker dataBroker, SfcPotNetconfNodeManager nodeManager) {
        super(dataBroker, LogicalDatastoreType.OPERATIONAL, InstanceIdentifier.builder(NetworkTopology.class).child(Topology.class).child(Node.class).build());
        this.nodeManager = nodeManager;
        this.ioamNetconfCapabilities = this.initializeIoamNetconfCapabilities();
    }

    private List<String> initializeIoamNetconfCapabilities() {
        String netconf = "urn:ietf:params:netconf:base:1.0";
        String ioamPot = "(urn:cisco:params:xml:ns:yang:sfc-ioam-sb-pot?revision=2017-01-12)sfc-ioam-sb-pot";
        String[] capabilityEntries = new String[]{"urn:ietf:params:netconf:base:1.0", "(urn:cisco:params:xml:ns:yang:sfc-ioam-sb-pot?revision=2017-01-12)sfc-ioam-sb-pot"};
        return Arrays.asList(capabilityEntries);
    }

    public void add(@Nonnull Node node) {
        this.update(node, node);
    }

    public void remove(@Nonnull Node node) {
        if (this.isIoamCapableNetconfDevice(node)) {
            this.nodeManager.removeNode(node);
        }
    }

    public void update(@Nonnull Node originalNode, @Nonnull Node updatedNode) {
        if (this.isIoamCapableNetconfDevice(updatedNode)) {
            this.nodeManager.updateNode(updatedNode);
        }
    }

    private boolean isIoamCapableNetconfDevice(Node node) {
        NetconfNode netconfAugmentation = (NetconfNode)node.getAugmentation(NetconfNode.class);
        if (netconfAugmentation == null) {
            LOG.debug("iOAM:PoT:SB:Node {} is not a netconf device", (Object)node.getNodeId().getValue());
            return false;
        }
        AvailableCapabilities capabilities = netconfAugmentation.getAvailableCapabilities();
        return capabilities != null && capabilities.getAvailableCapability().stream().map(AvailableCapability::getCapability).collect(Collectors.toList()).containsAll(this.ioamNetconfCapabilities);
    }
}

