/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.sfc.pot.netconf.renderer.provider;

import io.netty.util.Timeout;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.sfc.pot.netconf.renderer.provider.SfcPotNetconfNodeManager;
import org.opendaylight.sfc.pot.netconf.renderer.provider.SfcPotTimerData;
import org.opendaylight.sfc.pot.netconf.renderer.provider.SfcPotTimerTask;
import org.opendaylight.sfc.pot.netconf.renderer.provider.SfcPotTimerWheel;
import org.opendaylight.sfc.pot.netconf.renderer.provider.api.SfcPotPolyAPI;
import org.opendaylight.sfc.pot.netconf.renderer.utils.SfcPotNetconfReaderWriterAPI;
import org.opendaylight.sfc.provider.api.SfcProviderRenderedPathAPI;
import org.opendaylight.sfc.provider.api.SfcProviderServiceChainAPI;
import org.opendaylight.sfc.provider.api.SfcProviderServiceForwarderAPI;
import org.opendaylight.sfc.provider.api.SfcProviderServicePathAPI;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.RspName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SfcName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SffName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SfpName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.BitMaskOptions;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.RspIoamPotAugmentation;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.TimeResolution;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.hop.params.rev161205.PolySecrets;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.hop.params.rev161205.poly.secrets.PolySecret;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.params.rev161205.PolyParameters;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.params.rev161205.poly.parameters.PolyParameter;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.params.rev161205.poly.parameters.poly.parameter.Coeffs;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.params.rev161205.poly.parameters.poly.parameter.Lpcs;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.rev170112.PotProfiles;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.rev170112.PotProfilesBuilder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.rev170112.ProfileIndexRange;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.rev170112.pot.profile.PotProfileList;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.rev170112.pot.profile.PotProfileListBuilder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.rev170112.pot.profiles.PotProfileSet;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.rev170112.pot.profiles.PotProfileSetBuilder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.rendered.service.paths.RenderedServicePath;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.rendered.service.paths.rendered.service.path.RenderedServicePathHop;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfc.rev140701.service.function.chain.grouping.ServiceFunctionChain;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.rev140701.service.function.forwarders.ServiceFunctionForwarder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfp.rev140701.service.function.paths.ServiceFunctionPath;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SfcPotNetconfIoam {
    private static final Logger LOG = LoggerFactory.getLogger(SfcPotNetconfIoam.class);
    private static final long MIN_CFG_REFRESH_INTERVAL_MS = 500L;
    private static final long DEF_CFG_REFRESH_INTERVAL_MS = 5000L;
    private static final long CFG_REFRESH_INTERVAL_FUZZ_MS = 250L;
    private static final long DEF_NUM_POT_PROFILES = 2L;
    private static final long MIN_SFC_SIZE = 3L;
    private static final InstanceIdentifier<PotProfiles> POT_PROFILES_IID = InstanceIdentifier.create(PotProfiles.class);
    private final Map<String, HashSet<Config>> pathConfig;
    private final SfcPotNetconfNodeManager nodeManager;

    @Inject
    public SfcPotNetconfIoam(SfcPotNetconfNodeManager sfcPotNetconfNodeManager) {
        this.nodeManager = sfcPotNetconfNodeManager;
        this.pathConfig = new HashMap<String, HashSet<Config>>();
    }

    private List<BigInteger> getCoefficients(PolyParameter params) {
        ArrayList<BigInteger> coeffs = new ArrayList<BigInteger>();
        for (Coeffs coeff : params.getCoeffs()) {
            coeffs.add(BigInteger.valueOf(coeff.getCoeff()));
        }
        return coeffs;
    }

    private List<Long> getLpcs(PolyParameter params) {
        ArrayList<Long> lpcs = new ArrayList<Long>();
        for (Lpcs lpc : params.getLpcs()) {
            lpcs.add(lpc.getLpc());
        }
        return lpcs;
    }

    private Short getBitMaskValue(BitMaskOptions bitMask) {
        short val;
        switch (bitMask) {
            case Bits16: {
                val = 16;
                break;
            }
            case Bits32: {
                val = 32;
                break;
            }
            case Bits64: {
                val = 64;
                break;
            }
            default: {
                val = 32;
            }
        }
        return val;
    }

    private int sendIoamPotConfig(RenderedServicePath rsp, SfcPotPolyAPI potApi, HashSet<Config> configHash, int newActiveIndex) {
        SffName sffName;
        int posIndex = 0;
        String rspName = rsp.getName().getValue();
        PolyParameters ioamPotParams = potApi.getIoamPotParameters();
        if (ioamPotParams == null) {
            LOG.warn("iOAM:PoT:SB:profile parameters not present in RSP:{}", (Object)rsp.getName());
            return -1;
        }
        List hopList = rsp.getRenderedServicePathHop();
        for (RenderedServicePathHop h : hopList) {
            sffName = h.getServiceFunctionForwarder();
            NodeId sffNode = this.getSffNodeId(sffName);
            if (sffNode == null) {
                LOG.warn("iOAM:PoT:SB:sffNode is null for sffName: {}", (Object)sffName);
                return -1;
            }
            PolySecrets ioamPotHopParams = potApi.getIoamPotHopParameters(posIndex);
            if (ioamPotHopParams == null) {
                LOG.warn("iOAM:PoT:SB:Hop parameters not available for RSP:{}", (Object)rsp.getName());
                return -1;
            }
            PotProfiles profile = this.buildProfile(rspName + '-' + h.getServiceIndex(), ioamPotParams, ioamPotHopParams, posIndex, -1);
            if (!this.configSF(configHash, sffNode, profile)) {
                return -1;
            }
            ++posIndex;
        }
        posIndex = 0;
        RenderedServicePathHop hop = (RenderedServicePathHop)hopList.iterator().next();
        sffName = hop.getServiceFunctionForwarder();
        NodeId sffNode = this.getSffNodeId(sffName);
        if (sffNode == null) {
            LOG.warn("iOAM:PoT:SB:sffNode is null for sffName: {}", (Object)sffName);
            return -1;
        }
        PolySecrets ioamPotHopParams = potApi.getIoamPotHopParameters(posIndex);
        if (ioamPotHopParams == null) {
            LOG.warn("iOAM:PoT:SB: Hop parameters cannot be got for RSP:{}", (Object)rsp.getName());
            return -1;
        }
        PotProfiles profile = this.buildProfile(rspName + '-' + hop.getServiceIndex(), ioamPotParams, ioamPotHopParams, posIndex, newActiveIndex);
        if (!this.configSF(configHash, sffNode, profile)) {
            return -1;
        }
        return newActiveIndex;
    }

    private int processRspIoamPot(RenderedServicePath rsp, int sfcSize, Class<? extends TimeResolution> refreshPeriodTimeUnits, Long refreshPeriodValue, BitMaskOptions ioamPotProfileBitMask, Long ioamPotNumProfiles, int currActiveIndex, boolean flagRenew) {
        int ret;
        int newActiveIndex = currActiveIndex;
        String rspName = rsp.getName().getValue();
        HashSet<Config> configHash = new HashSet<Config>();
        SfcPotPolyAPI potApi = SfcPotPolyAPI.getInstance();
        if (potApi == null) {
            LOG.warn("iOAM:PoT:SB: Error in initialization.");
            return -1;
        }
        if (!flagRenew) {
            if (!potApi.init(rsp.getName().getValue(), sfcSize, refreshPeriodTimeUnits, refreshPeriodValue, ioamPotProfileBitMask, ioamPotNumProfiles)) {
                LOG.warn("iOAM:PoT:SB: Profile not initialized for RSP:{}", (Object)rsp.getName());
                return -1;
            }
        } else {
            newActiveIndex = potApi.initRenew(rsp.getName().getValue(), sfcSize, currActiveIndex);
            if (newActiveIndex == -1) {
                LOG.warn("iOAM:PoT:SB: Profile could not be renewed for RSP:{}", (Object)rsp.getName());
                return -1;
            }
        }
        if ((ret = this.sendIoamPotConfig(rsp, potApi, configHash, newActiveIndex)) == -1) {
            LOG.warn("iOAM:PoT:SB:profile could not be sent for RSP:{}", (Object)rsp.getName());
            return -1;
        }
        if (!flagRenew) {
            SfcPotTimerTask potTimerTask = new SfcPotTimerTask(rsp.getName());
            SfcPotTimerWheel potTimerWheel = SfcPotTimerWheel.getInstance();
            SfcPotTimerData potTimerData = SfcPotTimerData.getInstance();
            Long adjRefreshPeriodValue = refreshPeriodValue - 250L;
            Timeout potTimeout = potTimerWheel.setTimerContext(potTimerTask, adjRefreshPeriodValue, TimeUnit.MILLISECONDS);
            potTimerData.addRspData(rsp.getName(), adjRefreshPeriodValue, refreshPeriodTimeUnits, 0, sfcSize, potTimerTask, potTimeout);
            LOG.debug("iOAM:PoT:SB:Started timer for RSP:{}, sfc:{}", (Object)rsp.getName(), (Object)sfcSize);
            this.pathConfig.put(rspName, configHash);
            return 0;
        }
        return newActiveIndex;
    }

    private PotProfiles buildProfile(String profileName, PolyParameters params, PolySecrets secrets, int posIndex, int activeIndex) {
        List paramList = params.getPolyParameter();
        List secretList = secrets.getPolySecret();
        BitMaskOptions ioamPotProfileBitMask = params.getProfileBitMaskValue();
        Short bitMaskValue = this.getBitMaskValue(ioamPotProfileBitMask);
        long numProfiles = paramList.size();
        ArrayList<PotProfileList> potProfileList = new ArrayList<PotProfileList>();
        int j = 0;
        while ((long)j < numProfiles) {
            PotProfileListBuilder builder = new PotProfileListBuilder();
            PolyParameter paramObj = (PolyParameter)paramList.get(j);
            PolySecret secretObj = (PolySecret)secretList.get(j);
            List<BigInteger> coeffs = this.getCoefficients(paramObj);
            List<Long> lpcs = this.getLpcs(paramObj);
            builder.setIndex(new ProfileIndexRange(Integer.valueOf(j))).setPrimeNumber(BigInteger.valueOf(paramObj.getPrime())).setLpc(BigInteger.valueOf(lpcs.get(posIndex))).setSecretShare(BigInteger.valueOf(secretObj.getSecretShare())).setPublicPolynomial(coeffs.get(posIndex)).setNumberOfBits(bitMaskValue);
            if (secretObj.getSecret() != null) {
                builder.setValidator(Boolean.valueOf(true)).setValidatorKey(BigInteger.valueOf(secretObj.getSecret()));
            } else {
                builder.setValidator(Boolean.valueOf(false));
            }
            potProfileList.add(builder.build());
            ++j;
        }
        PotProfileSetBuilder sbuilder = new PotProfileSetBuilder();
        sbuilder.setPotProfileList(potProfileList).setName(profileName).setActiveProfileIndex(new ProfileIndexRange(Integer.valueOf(activeIndex))).setPathIdentifier(null);
        ArrayList<PotProfileSet> potProfileSet = new ArrayList<PotProfileSet>();
        potProfileSet.add(sbuilder.build());
        PotProfilesBuilder pbuilder = new PotProfilesBuilder();
        pbuilder.setPotProfileSet(potProfileSet);
        return pbuilder.build();
    }

    private boolean configSF(HashSet<Config> configHash, NodeId nodeId, PotProfiles profile) {
        InstanceIdentifier<PotProfiles> iid = POT_PROFILES_IID;
        DataBroker broker = this.nodeManager.getMountPointFromNodeId(nodeId);
        if (broker == null) {
            LOG.warn("iOAM:SB:PoT:Error configuring SF node. Broker invalid.");
            return false;
        }
        if (!SfcPotNetconfReaderWriterAPI.put(broker, LogicalDatastoreType.CONFIGURATION, iid, profile)) {
            LOG.warn("iOAM:SB:PoT:Error configuring SF node {} via NETCONF", (Object)nodeId.getValue());
            return false;
        }
        LOG.info("iOAM:SB:PoT:Successfully configured SF node {}", (Object)nodeId.getValue());
        configHash.add(new Config(nodeId, iid, broker));
        return true;
    }

    private NodeId getSffNodeId(SffName sffName) {
        if (sffName == null) {
            LOG.warn("iOAM:PoT:SB:SFF name invalid");
            return null;
        }
        ServiceFunctionForwarder sfcForwarder = SfcProviderServiceForwarderAPI.readServiceFunctionForwarder((SffName)sffName);
        if (sfcForwarder == null) {
            LOG.warn("iOAM:PoT:SB:SFF name {} not found in data store", (Object)sffName.getValue());
            return null;
        }
        IpAddress sffMgmtIp = sfcForwarder.getIpMgmtAddress();
        if (sffMgmtIp == null) {
            LOG.warn("iOAM:PoT:SB:Unable to obtain management IP for SFF {}", (Object)sffName.getValue());
            return null;
        }
        return this.nodeManager.getNodeIdFromIpAddress(new IpAddress(new Ipv4Address(sffMgmtIp.getIpv4Address().getValue())));
    }

    public void processRspUpdate(RenderedServicePath rsp) {
        BitMaskOptions ioamPotProfileBitMask;
        int ret;
        ServiceFunctionChain serviceFunctionChain;
        SfcPotTimerData potTimerData = SfcPotTimerData.getInstance();
        if (rsp == null) {
            LOG.warn("iOAM:PoT:SB:RSP is invalid.");
            return;
        }
        String rspName = rsp.getName().getValue();
        SfpName sfpName = rsp.getParentServiceFunctionPath();
        if (sfpName == null) {
            LOG.warn("iOAM:PoT:SB:ServiceFunctionPath is invalid.");
            return;
        }
        ServiceFunctionPath sfp = SfcProviderServicePathAPI.readServiceFunctionPath((SfpName)sfpName);
        SfcName serviceFunctionChainNameObj = sfp.getServiceChainName();
        ServiceFunctionChain serviceFunctionChain2 = serviceFunctionChain = serviceFunctionChainNameObj != null ? SfcProviderServiceChainAPI.readServiceFunctionChain((SfcName)serviceFunctionChainNameObj) : null;
        if (serviceFunctionChain == null) {
            LOG.warn("iOAM:PoT:SB:SFC name for Path {} is null.", (Object)sfp.getName());
            return;
        }
        int sfcSize = serviceFunctionChain.getSfcServiceFunction().size();
        if ((long)sfcSize < 3L) {
            LOG.warn("iOAM:PoT:SB:Service Function Chain size:{} is unsupported.", (Object)sfcSize);
            return;
        }
        RspIoamPotAugmentation potAugmentation = (RspIoamPotAugmentation)rsp.getAugmentation(RspIoamPotAugmentation.class);
        if (potAugmentation == null) {
            LOG.warn("iOAM:PoT:SB:RSP {}:iOAM not supported.", (Object)rsp.getName());
            return;
        }
        if (!potAugmentation.isIoamPotEnable().booleanValue()) {
            LOG.info("iOAM:PoT:SB:RSP {}:iOAM Proof of Transit disabled.", (Object)rsp.getName());
            SfcPotTimerWheel timer = SfcPotTimerWheel.getInstance();
            timer.clearTimerContext(potTimerData.getRspDataTimeout(rsp.getName()));
            potTimerData.delRspData(rsp.getName());
            return;
        }
        if (potTimerData.isRspDataPresent(rsp.getName())) {
            LOG.warn("iOAM:PoT:SB:RSP {}:PoT parameters updates not supported.", (Object)rsp.getName());
            return;
        }
        Class refreshPeriodTimeUnits = potAugmentation.getRefreshPeriodTimeUnits();
        Long refreshPeriodValue = potAugmentation.getRefreshPeriodValue();
        Long ioamPotNumProfiles = potAugmentation.getIoamPotNumProfiles();
        LOG.debug("iOAM:PoT:SB:RSP {}:Got iOAM Proof of Transit params:{}", (Object)rsp.getName(), (Object)potAugmentation);
        if (refreshPeriodValue < 500L) {
            LOG.warn("iOAM:PoT:SB:RSP {}: Got unsupported refresh period value:{}.using default.", (Object)rspName, (Object)refreshPeriodValue);
            refreshPeriodValue = 5000L;
        }
        if (ioamPotNumProfiles < 2L) {
            LOG.warn("iOAM:PoT:SB:RSP {}: Got unsupported profile num:{}...using default.", (Object)rspName, (Object)ioamPotNumProfiles);
            ioamPotNumProfiles = 2L;
        }
        if ((ret = this.processRspIoamPot(rsp, sfcSize, refreshPeriodTimeUnits, refreshPeriodValue, ioamPotProfileBitMask = potAugmentation.getIoamPotBitMask(), ioamPotNumProfiles, 0, false)) < 0) {
            LOG.warn("iOAM:PoT:SB:RSP:{} processing error in proof of transit.", (Object)rsp.getName());
        } else {
            LOG.debug("iOAM:PoT:SB:RSP:{} processing done for proof of transit.", (Object)rsp.getName());
        }
    }

    public int refreshSfcPot(RspName rspName, int currActiveIndex, int sfcSize, Long refreshPeriodValue) {
        RenderedServicePath rsp = SfcProviderRenderedPathAPI.readRenderedServicePath((RspName)rspName);
        if (rsp == null) {
            LOG.warn("iOAM:PoT:SB:RSP for SFC: {} is invalid.", (Object)rspName);
            return -1;
        }
        if (sfcSize == 0) {
            LOG.warn("iOAM:PoT:SB:Service Function Chain is empty.");
            return -1;
        }
        return this.processRspIoamPot(rsp, sfcSize, null, refreshPeriodValue, null, null, currActiveIndex, true);
    }

    public void deleteRsp(RenderedServicePath rsp) {
        HashSet<Config> configHash = this.pathConfig.get(rsp.getName().getValue());
        SfcPotTimerData potTimerData = SfcPotTimerData.getInstance();
        SfcPotTimerWheel timer = SfcPotTimerWheel.getInstance();
        timer.clearTimerContext(potTimerData.getRspDataTimeout(rsp.getName()));
        potTimerData.delRspData(rsp.getName());
        if (configHash != null) {
            for (Config cfg : configHash) {
                LOG.debug("iOAM:PoT:SB:Cleaning up for node:{}", (Object)cfg.nodeId);
                SfcPotNetconfReaderWriterAPI.delete(cfg.broker, LogicalDatastoreType.CONFIGURATION, cfg.iid);
            }
            this.pathConfig.remove(rsp.getName().getValue());
        }
    }

    private static class Config {
        NodeId nodeId;
        InstanceIdentifier<PotProfiles> iid;
        DataBroker broker;

        Config(NodeId nodeId, InstanceIdentifier<PotProfiles> iid, DataBroker broker) {
            this.nodeId = nodeId;
            this.iid = iid;
            this.broker = broker;
        }
    }
}

