/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.sfc.pot.netconf.renderer.provider;

import io.netty.util.Timeout;
import java.util.concurrent.TimeUnit;
import org.opendaylight.sfc.pot.netconf.renderer.provider.SfcPotNetconfIoam;
import org.opendaylight.sfc.pot.netconf.renderer.provider.SfcPotTimerData;
import org.opendaylight.sfc.pot.netconf.renderer.provider.SfcPotTimerQueue;
import org.opendaylight.sfc.pot.netconf.renderer.provider.SfcPotTimerWheel;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.RspName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SfcPotTimerThread
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SfcPotTimerThread.class);
    private static final int SLEEP_TIME_MS = 1000;
    private final Thread configRefresher;
    private final SfcPotTimerQueue sfcPotTimerQueue = SfcPotTimerQueue.getInstance();
    private SfcPotNetconfIoam sfcPotNetconfIoam;
    private boolean doLoop = true;
    private static final SfcPotTimerThread SFC_POT_TIMER_THREAD = new SfcPotTimerThread();

    private SfcPotTimerThread() {
        this.configRefresher = new Thread(this);
        this.configRefresher.start();
    }

    public static SfcPotTimerThread getInstance() {
        return SFC_POT_TIMER_THREAD;
    }

    public void setSfcPotRspProcessor(SfcPotNetconfIoam netconfIoam) {
        this.sfcPotNetconfIoam = netconfIoam;
    }

    public void triggerConfigRefresher() {
        this.configRefresher.interrupt();
    }

    public void stopConfigRefresher() {
        this.doLoop = false;
        this.triggerConfigRefresher();
    }

    @Override
    public void run() {
        while (this.doLoop) {
            boolean processRsp = this.sfcPotTimerQueue.hasElements();
            if (processRsp) {
                RspName rspName = this.sfcPotTimerQueue.removeElement();
                SfcPotTimerData potTimerData = SfcPotTimerData.getInstance();
                int newActiveIndex = 0;
                if (potTimerData != null) {
                    Long refreshTimerValue = potTimerData.getRspDataConfigRefreshValue(rspName);
                    int currActiveIndex = potTimerData.getRspDataConfigActiveIndex(rspName);
                    int sfcSize = potTimerData.getRspDataSfcSize(rspName);
                    if (this.sfcPotNetconfIoam != null) {
                        newActiveIndex = this.sfcPotNetconfIoam.refreshSfcPot(rspName, currActiveIndex, sfcSize, refreshTimerValue);
                    }
                    if (newActiveIndex >= 0) {
                        SfcPotTimerWheel potTimerWheel = SfcPotTimerWheel.getInstance();
                        Timeout potTimeout = potTimerWheel.setTimerContext(potTimerData.getRspDataTimerTask(rspName), refreshTimerValue, TimeUnit.MILLISECONDS);
                        potTimerData.setRspDataTimeout(rspName, potTimeout);
                        potTimerData.setRspDataConfigActiveIndex(rspName, newActiveIndex);
                    }
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.warn("Thread interrupted while sleeping... {} ", (Throwable)e);
            }
        }
    }
}

