/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.sfc.pot.netconf.renderer.provider.api;

import java.math.BigInteger;
import java.util.Random;

public class SfcPotConfigGenerator {
    private static final String VERSION = "0.5";
    private static final int MAX_SERVICE_NODES = 100;
    private static final short DEFAULT_NUM_BITS = 60;
    private short noOfBits;
    private int noOfServices = -1;
    private long numLimit = 0L;
    private final long[] secretSharePoly1;
    private long[] coeffOfPoly1;
    private long[] coeffOfPoly2;
    private BigInteger bigPrime;
    private final short[] serviceIndices;
    private final BigInteger[] preEvalPoly2;
    private final BigInteger[] lpcs;

    public SfcPotConfigGenerator(int noOfServices) {
        this.noOfServices = noOfServices;
        this.secretSharePoly1 = new long[noOfServices];
        this.serviceIndices = new short[noOfServices];
        this.preEvalPoly2 = new BigInteger[noOfServices];
        this.lpcs = new BigInteger[noOfServices];
        this.setNoOfBits((short)60);
    }

    private void setupCoeffPrime() {
        long largestCoeff = 0L;
        this.coeffOfPoly1 = new long[this.noOfServices];
        this.coeffOfPoly2 = new long[this.noOfServices];
        for (int i = 0; i < this.noOfServices; ++i) {
            this.coeffOfPoly1[i] = 0L;
            this.coeffOfPoly2[i] = 0L;
            Random randomNumber = new Random();
            this.coeffOfPoly1[i] = this.absLong(randomNumber.nextLong()) % this.numLimit + 1L;
            this.coeffOfPoly2[i] = this.absLong(randomNumber.nextLong()) % this.numLimit + 1L;
            if (this.coeffOfPoly1[i] > largestCoeff) {
                largestCoeff = this.coeffOfPoly1[i];
            }
            if (this.coeffOfPoly2[i] <= largestCoeff) continue;
            largestCoeff = this.coeffOfPoly2[i];
        }
        this.bigPrime = new BigInteger(Long.toUnsignedString(largestCoeff)).nextProbablePrime();
    }

    private BigInteger evaluatePoly(int x, long[] coefficients) {
        BigInteger precomputeShare = new BigInteger("0");
        BigInteger powX = new BigInteger("1");
        for (int exp = 1; exp < this.noOfServices; ++exp) {
            powX = powX.multiply(new BigInteger("" + x));
            BigInteger term = powX.multiply(new BigInteger(Long.toUnsignedString(coefficients[exp])));
            precomputeShare = precomputeShare.add(term);
        }
        precomputeShare = precomputeShare.mod(this.bigPrime);
        return precomputeShare;
    }

    private long splitShareIndex(int index) {
        BigInteger bigShare = this.evaluatePoly(index, this.coeffOfPoly1);
        bigShare = bigShare.add(new BigInteger(Long.toUnsignedString(this.coeffOfPoly1[0])));
        bigShare = bigShare.remainder(this.bigPrime);
        return bigShare.longValue();
    }

    private BigInteger calculateLpc(int index) {
        BigInteger bigDenom = new BigInteger("1");
        BigInteger bigNumerator = new BigInteger("1");
        for (int count = 0; count < this.noOfServices; ++count) {
            if (index == count) continue;
            long startPosition = this.serviceIndices[index];
            long nextPosition = this.serviceIndices[count];
            bigNumerator = bigNumerator.multiply(new BigInteger(Long.toString(-1L * nextPosition)));
            bigNumerator = bigNumerator.mod(this.bigPrime);
            bigDenom = bigDenom.multiply(new BigInteger(Long.toString(startPosition - nextPosition)));
            bigDenom = bigDenom.mod(this.bigPrime);
        }
        bigDenom = bigDenom.modInverse(this.bigPrime);
        BigInteger bigLpc = bigNumerator.multiply(bigDenom);
        bigLpc = bigLpc.mod(this.bigPrime);
        return bigLpc;
    }

    private void setupServiceIndices() {
        for (int i = 0; i < this.noOfServices; ++i) {
            this.serviceIndices[i] = (short)((i + 1) * 2);
        }
        Random randomNumber = new Random();
        for (int i = 0; i < this.noOfServices; ++i) {
            int index = randomNumber.nextInt(this.noOfServices);
            Short temp = this.serviceIndices[i];
            this.serviceIndices[i] = this.serviceIndices[index];
            this.serviceIndices[index] = temp;
        }
    }

    private void setupSecretSharePoly1() {
        for (int i = 0; i < this.noOfServices; ++i) {
            this.secretSharePoly1[i] = this.splitShareIndex(this.serviceIndices[i]);
        }
    }

    private void setupLpcs() {
        for (int i = 0; i < this.noOfServices; ++i) {
            this.lpcs[i] = this.calculateLpc(i);
        }
    }

    private void setupPreEvalPoly2() {
        for (int i = 0; i < this.noOfServices; ++i) {
            this.preEvalPoly2[i] = this.evaluatePoly(this.serviceIndices[i], this.coeffOfPoly2);
        }
    }

    public void generateScvConfig() {
        this.setupCoeffPrime();
        this.setupServiceIndices();
        this.setupSecretSharePoly1();
        this.setupLpcs();
        this.setupPreEvalPoly2();
    }

    private long absLong(long number) {
        return number << 1 >>> 1;
    }

    public int getNoOfServices() {
        return this.noOfServices;
    }

    public void setNoOfServices(int noOfServices) {
        this.noOfServices = noOfServices;
    }

    public short getNoOfBits() {
        return this.noOfBits;
    }

    public void setNoOfBits(short noOfBits) {
        this.noOfBits = (short)Math.min(64, noOfBits);
        this.numLimit = (long)Math.pow(2.0, this.noOfBits);
    }

    public String getVersion() {
        return VERSION;
    }

    public int getMaxServiceNodes() {
        return 100;
    }

    public Long getPrime() {
        return this.bigPrime.longValue();
    }

    public Long getSecret() {
        return this.coeffOfPoly1[0];
    }

    public long getNumLimit() {
        return this.numLimit;
    }

    public Short getServiceIndices(int index) {
        return this.serviceIndices[index];
    }

    public short[] getServiceIndices() {
        short[] res = new short[this.serviceIndices.length];
        System.arraycopy(this.serviceIndices, 0, res, 0, this.serviceIndices.length);
        return res;
    }

    public long getSecretShare(int index) {
        return this.secretSharePoly1[index];
    }

    public BigInteger getPublicPoly(int index) {
        return this.preEvalPoly2[index];
    }

    public void setNumLimit(long numLimit) {
        short numofbits = (short)Math.ceil(Math.log(Math.max(2L, numLimit)) / Math.log(2.0));
        this.setNoOfBits(numofbits);
    }

    public BigInteger[] getLpcs() {
        BigInteger[] res = new BigInteger[this.lpcs.length];
        System.arraycopy(this.lpcs, 0, res, 0, this.lpcs.length);
        return res;
    }

    public long getCoeff(int index) {
        return this.coeffOfPoly1[index];
    }

    public BigInteger getLpc(int index) {
        return this.lpcs[index];
    }
}

