/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.sfc.pot.netconf.renderer.utils;

import com.google.common.util.concurrent.CheckedFuture;
import java.util.concurrent.ExecutionException;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SfcPotNetconfReaderWriterAPI {
    private static final Logger LOG = LoggerFactory.getLogger(SfcPotNetconfReaderWriterAPI.class);

    private SfcPotNetconfReaderWriterAPI() {
    }

    public static <T extends DataObject> boolean put(DataBroker broker, LogicalDatastoreType logicalDatastoreType, InstanceIdentifier<T> iid, T dataObject) {
        try {
            WriteTransaction tx = broker.newWriteOnlyTransaction();
            tx.put(logicalDatastoreType, iid, dataObject);
            CheckedFuture future = tx.submit();
            future.get();
            return true;
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("iOAM:PoT:SB:Netconf put to nodeid: failed:", (Throwable)e);
            return false;
        }
    }

    public static <T extends DataObject> boolean delete(DataBroker broker, LogicalDatastoreType logicalDatastoreType, InstanceIdentifier<T> iid) {
        try {
            WriteTransaction tx = broker.newWriteOnlyTransaction();
            tx.delete(logicalDatastoreType, iid);
            CheckedFuture future = tx.submit();
            future.get();
            return true;
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("iOAM:PoT:SB:Netconf delete to nodeid failed:", (Throwable)e);
            return false;
        }
    }
}

