/*
 * Copyright (c) 2016, 2017 Cisco Systems, Inc. and others.  All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 */

package org.opendaylight.sfc.pot.netconf.renderer.provider.api;

import java.util.List;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.params.rev161205.poly.parameters.poly.parameter.Coeffs;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.params.rev161205.poly.parameters.poly.parameter.Lpcs;

/**
 * This template class is used to store south-bound configuration for SFC
 * verification.
 *
 * @author Srihari Raghavan (srihari@cisco.com)
 * @version 0.1
 * @since 2016-05-01
 */
public class SfcPotPolyClass {
    private final long prime;
    private final long secret;
    private final long sfcsize;
    private final List<Coeffs> coeffs;
    private final List<Long> shares;
    private final List<Lpcs> lpcs;

    SfcPotPolyClass(long prime, long secret, List<Coeffs> coeffs, List<Long> shares, List<Lpcs> lpcs, long sfcsize) {
        this.prime = prime;
        this.secret = secret;
        this.coeffs = coeffs;
        this.shares = shares;
        this.lpcs = lpcs;
        this.sfcsize = sfcsize;
    }

    public List<Coeffs> getCoeffs() {
        return this.coeffs;
    }

    public List<Lpcs> getLpcs() {
        return this.lpcs;
    }

    public long getPrime() {
        return this.prime;
    }

    public long getSecret() {
        return this.secret;
    }

    public List<Long> getShares() {
        return this.shares;
    }

    public long getSfcSize() {
        return this.sfcsize;
    }
}
