/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.sfc.pot.netconf.renderer;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.sfc.pot.netconf.renderer.provider.SfcPotNetconfIoam;
import org.opendaylight.sfc.pot.netconf.renderer.provider.SfcPotTimerQueue;
import org.opendaylight.sfc.pot.netconf.renderer.provider.SfcPotTimerThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SfcPotNetconfRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(SfcPotNetconfRenderer.class);
    private final SfcPotNetconfIoam sfcPotNetconfIoam;

    @Inject
    public SfcPotNetconfRenderer(SfcPotNetconfIoam sfcPotNetconfIoam) {
        this.sfcPotNetconfIoam = sfcPotNetconfIoam;
    }

    @PostConstruct
    public void initialize() {
        SfcPotTimerThread sfcPotTimerThread = SfcPotTimerThread.getInstance();
        sfcPotTimerThread.setSfcPotRspProcessor(this.sfcPotNetconfIoam);
        sfcPotTimerThread.triggerConfigRefresher();
        LOG.info("iOAM:PoT:SB:Netconf renderer started.");
    }

    @PreDestroy
    public void unregisterListeners() {
        SfcPotTimerQueue queue = SfcPotTimerQueue.getInstance();
        queue.clearTimerQueue();
        SfcPotTimerThread sfcPotTimerThread = SfcPotTimerThread.getInstance();
        sfcPotTimerThread.stopConfigRefresher();
        LOG.info("iOAM:PoT:SB:Netconf renderer stopped.");
    }
}

