/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.sfc.pot.netconf.renderer.listener;

import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.serviceutils.tools.mdsal.listener.AbstractSyncDataTreeChangeListener;
import org.opendaylight.sfc.pot.netconf.renderer.provider.SfcPotNetconfIoam;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.RenderedServicePaths;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.rendered.service.paths.RenderedServicePath;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SfcPotNetconfRSPListener
extends AbstractSyncDataTreeChangeListener<RenderedServicePath> {
    private static final Logger LOG = LoggerFactory.getLogger(SfcPotNetconfRSPListener.class);
    private final SfcPotNetconfIoam sfcPotNetconfIoam;

    @Inject
    public SfcPotNetconfRSPListener(DataBroker dataBroker, SfcPotNetconfIoam sfcPotNetconfIoam) {
        super(dataBroker, LogicalDatastoreType.OPERATIONAL, InstanceIdentifier.builder(RenderedServicePaths.class).child(RenderedServicePath.class).build());
        this.sfcPotNetconfIoam = sfcPotNetconfIoam;
    }

    public void add(@Nonnull InstanceIdentifier<RenderedServicePath> instanceIdentifier, @Nonnull RenderedServicePath renderedServicePath) {
        this.update((DataObject)renderedServicePath, (DataObject)renderedServicePath);
    }

    public void remove(@Nonnull InstanceIdentifier<RenderedServicePath> instanceIdentifier, @Nonnull RenderedServicePath renderedServicePath) {
        LOG.debug("iOAM:PoT:SB:Deleted RSP: {}", (Object)renderedServicePath.getName());
        this.sfcPotNetconfIoam.deleteRsp(renderedServicePath);
    }

    public void update(@Nonnull InstanceIdentifier<RenderedServicePath> instanceIdentifier, @Nonnull RenderedServicePath originalRenderedServicePath, @Nonnull RenderedServicePath updatedRenderedServicePath) {
        LOG.debug("iOAM:PoT:SB:Updated RSP: {}", (Object)updatedRenderedServicePath.getName());
        this.sfcPotNetconfIoam.processRspUpdate(updatedRenderedServicePath);
    }
}

