/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.sfc.pot.netconf.renderer.provider;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.MountPointService;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNodeConnectionStatus;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SfcPotNetconfNodeManager {
    private static final Logger LOG = LoggerFactory.getLogger(SfcPotNetconfNodeManager.class);
    private final MountPointService mountService;
    private final TopologyId topologyId = new TopologyId("topology-netconf");
    private final Map<NodeId, Node> connectedNodes = new HashMap<NodeId, Node>();
    private final Map<NodeId, DataBroker> activeMountPoints = new HashMap<NodeId, DataBroker>();

    @Inject
    public SfcPotNetconfNodeManager(MountPointService mountService) {
        this.mountService = mountService;
    }

    public void updateNode(Node node) {
        NetconfNode netconfNode = (NetconfNode)node.augmentation(NetconfNode.class);
        NetconfNodeConnectionStatus.ConnectionStatus connectionStatus = netconfNode.getConnectionStatus();
        NodeId netconfNodeId = node.getNodeId();
        if (connectionStatus.equals((Object)NetconfNodeConnectionStatus.ConnectionStatus.Connected)) {
            this.connectedNodes.put(netconfNodeId, node);
            InstanceIdentifier mountPointIid = this.getMountPointIid(netconfNodeId);
            DataBroker dataBroker = this.getNetconfNodeDataBroker(mountPointIid);
            if (dataBroker != null) {
                this.activeMountPoints.put(netconfNodeId, dataBroker);
            } else {
                LOG.debug("iOAM:PoT:SB:Cannot obtain data broker for netconf node {}", (Object)netconfNodeId.getValue());
                this.connectedNodes.remove(netconfNodeId);
            }
        }
    }

    public void removeNode(Node node) {
        NetconfNode netconfNode = (NetconfNode)node.augmentation(NetconfNode.class);
        if (netconfNode == null) {
            LOG.warn("iOAM:PoT:SB: Netconf node is invalid.");
            return;
        }
        NetconfNodeConnectionStatus.ConnectionStatus connectionStatus = netconfNode.getConnectionStatus();
        NodeId netconfNodeId = node.getNodeId();
        switch (connectionStatus) {
            case Connected: {
                this.connectedNodes.remove(netconfNodeId);
                this.activeMountPoints.remove(netconfNodeId);
                LOG.info("iOAM:PoT:SB:Netconf node {} removed", (Object)netconfNodeId.getValue());
                break;
            }
        }
    }

    private DataBroker getNetconfNodeDataBroker(InstanceIdentifier mountPointIid) {
        DataBroker dataBroker = (DataBroker)this.mountService.getMountPoint(mountPointIid).transform(mp -> (DataBroker)mp.getService(DataBroker.class).orNull()).orNull();
        return dataBroker;
    }

    private InstanceIdentifier getMountPointIid(NodeId nodeId) {
        return InstanceIdentifier.builder(NetworkTopology.class).child(Topology.class, (Identifier)new TopologyKey(this.topologyId)).child(Node.class, (Identifier)new NodeKey(nodeId)).build();
    }

    public NodeId getNodeIdFromIpAddress(IpAddress ipAddress) {
        for (Node node : this.connectedNodes.values()) {
            if (!ipAddress.equals((Object)this.getNetconfNodeIp(node))) continue;
            return node.getNodeId();
        }
        return null;
    }

    public DataBroker getMountPointFromNodeId(NodeId nodeId) {
        return this.activeMountPoints.get(nodeId);
    }

    public IpAddress getNetconfNodeIp(Node node) {
        NetconfNode netconfNode = (NetconfNode)node.augmentation(NetconfNode.class);
        if (netconfNode == null) {
            LOG.warn("iOAM:PoT:SB: Netconf node is invalid.");
            return null;
        }
        return netconfNode.getHost().getIpAddress();
    }
}

