/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.sfc.pot.netconf.renderer.provider;

import io.netty.util.Timeout;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.sfc.pot.netconf.renderer.provider.SfcPotTimerTask;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.RspName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.TimeResolution;

public final class SfcPotTimerData {
    private static final SfcPotTimerData SFC_POT_TIMER_DATA_INSTANCE = new SfcPotTimerData();
    private final Map<String, SfcPotRspInfo> potRspInfoStore = new HashMap<String, SfcPotRspInfo>();

    private SfcPotTimerData() {
    }

    public static SfcPotTimerData getInstance() {
        return SFC_POT_TIMER_DATA_INSTANCE;
    }

    public boolean isRspDataPresent(RspName rspName) {
        return this.potRspInfoStore != null && this.potRspInfoStore.get(rspName.getValue()) != null;
    }

    public boolean addRspData(RspName rspName, Long refreshPeriodValue, Class<? extends TimeResolution> refreshPeriodTimeUnits, int currActiveIndex, int sfcSize, SfcPotTimerTask potTimerTask, Timeout potTimeout) {
        if (this.potRspInfoStore == null) {
            return false;
        }
        SfcPotRspInfo potRspInfo = new SfcPotRspInfo(refreshPeriodValue, currActiveIndex, sfcSize, potTimerTask, potTimeout);
        this.potRspInfoStore.put(rspName.getValue(), potRspInfo);
        return true;
    }

    public void delRspData(RspName rspName) {
        if (this.potRspInfoStore == null) {
            return;
        }
        this.potRspInfoStore.remove(rspName.getValue());
    }

    public Long getRspDataConfigRefreshValue(RspName rspName) {
        Long ret = 0L;
        if (this.potRspInfoStore == null) {
            return ret;
        }
        SfcPotRspInfo potRspInfo = this.potRspInfoStore.get(rspName.getValue());
        if (potRspInfo != null) {
            return potRspInfo.configSendTimerValue;
        }
        return ret;
    }

    public int getRspDataConfigActiveIndex(RspName rspName) {
        if (this.potRspInfoStore == null) {
            return 0;
        }
        SfcPotRspInfo potRspInfo = this.potRspInfoStore.get(rspName.getValue());
        if (potRspInfo != null) {
            return potRspInfo.currActiveIndex;
        }
        return 0;
    }

    public int getRspDataSfcSize(RspName rspName) {
        if (this.potRspInfoStore == null) {
            return 0;
        }
        SfcPotRspInfo potRspInfo = this.potRspInfoStore.get(rspName.getValue());
        if (potRspInfo != null) {
            return potRspInfo.sfcSize;
        }
        return 0;
    }

    public boolean setRspDataConfigActiveIndex(RspName rspName, int newActiveIndex) {
        if (this.potRspInfoStore == null) {
            return false;
        }
        SfcPotRspInfo potRspInfo = this.potRspInfoStore.get(rspName.getValue());
        if (potRspInfo != null) {
            potRspInfo.currActiveIndex = newActiveIndex;
            this.potRspInfoStore.put(rspName.getValue(), potRspInfo);
            return true;
        }
        return false;
    }

    public SfcPotTimerTask getRspDataTimerTask(RspName rspName) {
        if (this.potRspInfoStore == null) {
            return null;
        }
        SfcPotRspInfo potRspInfo = this.potRspInfoStore.get(rspName.getValue());
        if (potRspInfo != null) {
            return potRspInfo.potTimerTask;
        }
        return null;
    }

    public Timeout getRspDataTimeout(RspName rspName) {
        if (this.potRspInfoStore == null) {
            return null;
        }
        SfcPotRspInfo potRspInfo = this.potRspInfoStore.get(rspName.getValue());
        if (potRspInfo != null) {
            return potRspInfo.potTimeout;
        }
        return null;
    }

    public void setRspDataTimeout(RspName rspName, Timeout potTimeout) {
        if (this.potRspInfoStore == null) {
            return;
        }
        SfcPotRspInfo potRspInfo = this.potRspInfoStore.get(rspName.getValue());
        if (potRspInfo != null) {
            potRspInfo.potTimeout = potTimeout;
            this.potRspInfoStore.put(rspName.getValue(), potRspInfo);
        }
    }

    private static class SfcPotRspInfo {
        Long configSendTimerValue;
        int currActiveIndex;
        SfcPotTimerTask potTimerTask;
        Timeout potTimeout;
        int sfcSize;

        SfcPotRspInfo(Long configVal, int currActiveIndex, int sfcSize, SfcPotTimerTask potTimerTask, Timeout potTimeout) {
            this.configSendTimerValue = configVal;
            this.currActiveIndex = currActiveIndex;
            this.sfcSize = sfcSize;
            this.potTimerTask = potTimerTask;
            this.potTimeout = potTimeout;
        }
    }
}

