/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.sfc.pot.netconf.renderer.provider.api;

import java.util.ArrayList;
import java.util.List;
import org.opendaylight.sfc.pot.netconf.renderer.provider.api.SfcPotConfigGenerator;
import org.opendaylight.sfc.pot.netconf.renderer.provider.api.SfcPotPolyClass;
import org.opendaylight.sfc.pot.netconf.renderer.provider.api.SfcPotPolyClassAPI;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.BitMaskOptions;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.TimeResolution;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.hop.params.rev161205.PolySecrets;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.hop.params.rev161205.PolySecretsBuilder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.hop.params.rev161205.poly.secrets.PolySecret;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.hop.params.rev161205.poly.secrets.PolySecretBuilder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.hop.params.rev161205.poly.secrets.PolySecretKey;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.params.rev161205.PolyParameters;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.params.rev161205.PolyParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.params.rev161205.poly.parameters.PolyParameter;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.params.rev161205.poly.parameters.PolyParameterBuilder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.params.rev161205.poly.parameters.PolyParameterKey;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.params.rev161205.poly.parameters.poly.parameter.Coeffs;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.params.rev161205.poly.parameters.poly.parameter.CoeffsBuilder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.params.rev161205.poly.parameters.poly.parameter.Lpcs;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.params.rev161205.poly.parameters.poly.parameter.LpcsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SfcPotPolyAPI {
    private static final Logger LOG = LoggerFactory.getLogger(SfcPotPolyAPI.class);
    private Class<? extends TimeResolution> refreshPeriodTimeUnits;
    private Long refreshPeriodValue;
    private BitMaskOptions ioamPotProfileBitMask;
    private Long ioamPotNumProfiles;
    private final SfcPotPolyClassAPI sfcPotPolyClassAPI = new SfcPotPolyClassAPI();
    private List<SfcPotPolyClass> polyClassList;
    private static final SfcPotPolyAPI SFC_POT_POLY_API_INSTANCE = new SfcPotPolyAPI();

    private SfcPotPolyAPI() {
    }

    public static SfcPotPolyAPI getInstance() {
        return SFC_POT_POLY_API_INSTANCE;
    }

    private int getNewActiveIndex(int currActiveIndex) {
        int numProfiles = this.ioamPotNumProfiles.intValue();
        return (currActiveIndex + 1) % numProfiles;
    }

    public boolean init(String rspName, int sfSize, Class<? extends TimeResolution> newRefreshPeriodTimeUnits, Long newRefreshPeriodValue, BitMaskOptions newIoamPotProfileBitMask, Long newIoamPotNumProfiles) {
        ArrayList<Object> coeffs = new ArrayList<Coeffs>();
        ArrayList<Long> shares = new ArrayList<Long>();
        ArrayList<Object> lpcs = new ArrayList<Lpcs>();
        if (this.polyClassList == null) {
            this.polyClassList = this.sfcPotPolyClassAPI.getPolyClassList(rspName);
            if (this.polyClassList == null) {
                this.polyClassList = new ArrayList<SfcPotPolyClass>();
            }
        }
        this.refreshPeriodTimeUnits = newRefreshPeriodTimeUnits;
        this.refreshPeriodValue = newRefreshPeriodValue;
        this.ioamPotProfileBitMask = newIoamPotProfileBitMask;
        this.ioamPotNumProfiles = newIoamPotNumProfiles;
        this.sfcPotPolyClassAPI.setNumProfiles(newIoamPotNumProfiles);
        SfcPotConfigGenerator configGenerator = new SfcPotConfigGenerator(sfSize);
        configGenerator.generateScvConfig();
        for (long j = 0L; j < newIoamPotNumProfiles; ++j) {
            int i;
            long prime = configGenerator.getPrime();
            long secret = configGenerator.getSecret();
            for (i = 1; i < sfSize; ++i) {
                coeffs.add(new CoeffsBuilder().setCoeff(Long.valueOf(configGenerator.getCoeff(i))).build());
                lpcs.add(new LpcsBuilder().setLpc(Long.valueOf(configGenerator.getLpc(i).longValue())).build());
            }
            for (i = 0; i < sfSize; ++i) {
                shares.add(configGenerator.getSecretShare(i));
            }
            this.polyClassList.add(new SfcPotPolyClass(prime, secret, coeffs, shares, lpcs, sfSize));
            coeffs = new ArrayList();
            shares = new ArrayList();
            lpcs = new ArrayList();
        }
        this.sfcPotPolyClassAPI.putPolyClassList(rspName, this.polyClassList);
        return true;
    }

    public int initRenew(String rspName, int sfSize, int currActiveIndex) {
        int i;
        ArrayList<Coeffs> coeffs = new ArrayList<Coeffs>();
        ArrayList<Long> shares = new ArrayList<Long>();
        ArrayList<Lpcs> lpcs = new ArrayList<Lpcs>();
        ArrayList<SfcPotPolyClass> polyClassListCopy = new ArrayList<SfcPotPolyClass>();
        if (this.polyClassList == null) {
            this.polyClassList = this.sfcPotPolyClassAPI.getPolyClassList(rspName);
            if (this.polyClassList == null) {
                LOG.warn("iOAM:PoT:SB:initRenew:Error in getting parameters for renew:RSP:{}", (Object)rspName);
                return -1;
            }
        }
        SfcPotConfigGenerator configGenerator = new SfcPotConfigGenerator(sfSize);
        configGenerator.generateScvConfig();
        boolean ret = polyClassListCopy.addAll(0, this.polyClassList);
        if (!ret) {
            LOG.warn("iOAM:PoT:SB:initRenew:Internal error...");
            return -1;
        }
        int newActiveIndex = this.getNewActiveIndex(currActiveIndex);
        long prime = configGenerator.getPrime();
        long secret = configGenerator.getSecret();
        for (i = 1; i < sfSize; ++i) {
            coeffs.add(new CoeffsBuilder().setCoeff(Long.valueOf(configGenerator.getCoeff(i))).build());
            lpcs.add(new LpcsBuilder().setLpc(Long.valueOf(configGenerator.getLpc(i).longValue())).build());
        }
        for (i = 0; i < sfSize; ++i) {
            shares.add(configGenerator.getSecretShare(i));
        }
        try {
            polyClassListCopy.set(newActiveIndex, new SfcPotPolyClass(prime, secret, coeffs, shares, lpcs, sfSize));
        }
        catch (IndexOutOfBoundsException err) {
            LOG.warn("iOAM:PoT:SB:Index out of bounds: {} ", (Object)newActiveIndex, (Object)err);
        }
        this.sfcPotPolyClassAPI.putPolyClassList(rspName, polyClassListCopy);
        this.polyClassList = this.sfcPotPolyClassAPI.getPolyClassList(rspName);
        LOG.debug("iOAM:PoT:SB:initRenew:Configuration updated at {}...", (Object)newActiveIndex);
        return newActiveIndex;
    }

    public PolySecrets getIoamPotHopParameters(int posIndex) {
        long numProfiles = this.sfcPotPolyClassAPI.getNumProfiles();
        if (this.polyClassList == null) {
            LOG.warn("iOAM:PoT:SB:setBuilderHopSecret: internal error.");
            return null;
        }
        PolySecretsBuilder polySecretsBuilder = new PolySecretsBuilder();
        ArrayList<PolySecret> polySecretList = new ArrayList<PolySecret>();
        for (long j = 0L; j < numProfiles; ++j) {
            PolySecretBuilder polySecretBuilder = new PolySecretBuilder();
            List<Long> shares = this.polyClassList.get((int)j).getShares();
            long secret = this.polyClassList.get((int)j).getSecret();
            polySecretBuilder.setSecretShare(shares.get(posIndex)).setPindex(Long.valueOf(j)).withKey(new PolySecretKey(Long.valueOf(j)));
            if (posIndex == shares.size() - 1) {
                polySecretBuilder.setSecret(Long.valueOf(secret));
            }
            polySecretList.add(polySecretBuilder.build());
        }
        polySecretsBuilder.setPolySecret(polySecretList);
        return polySecretsBuilder.build();
    }

    public PolyParameters getIoamPotParameters() {
        long numProfiles = this.sfcPotPolyClassAPI.getNumProfiles();
        if (this.polyClassList == null) {
            LOG.warn("iOAM:PoT:SB:setIoamPotParameters: polyclasslist internal error.");
            return null;
        }
        PolyParametersBuilder polyParamsBuilder = new PolyParametersBuilder();
        polyParamsBuilder.setRefreshPeriodTimeUnits(this.refreshPeriodTimeUnits).setRefreshPeriodValue(this.refreshPeriodValue).setProfileBitMaskValue(this.ioamPotProfileBitMask);
        ArrayList<PolyParameter> polyParameterList = new ArrayList<PolyParameter>();
        for (long j = 0L; j < numProfiles; ++j) {
            List<Coeffs> coeffs = this.polyClassList.get((int)j).getCoeffs();
            List<Lpcs> lpcs = this.polyClassList.get((int)j).getLpcs();
            long prime = this.polyClassList.get((int)j).getPrime();
            PolyParameterBuilder polyParameterBuilder = new PolyParameterBuilder();
            polyParameterBuilder.setPrime(Long.valueOf(prime)).setCoeffs(coeffs).setLpcs(lpcs).setPindex(Long.valueOf(j)).withKey(new PolyParameterKey(Long.valueOf(j)));
            polyParameterList.add(polyParameterBuilder.build());
        }
        polyParamsBuilder.setPolyParameter(polyParameterList);
        return polyParamsBuilder.build();
    }
}

