/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.sfc.pot.provider;

import com.google.common.util.concurrent.Futures;
import java.util.concurrent.Future;
import org.opendaylight.sfc.pot.provider.SfcPotRspProcessor;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.RspName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.DisableSfcIoamPotRenderedPathInput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.DisableSfcIoamPotRenderedPathOutput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.DisableSfcIoamPotRenderedPathOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.EnableSfcIoamPotRenderedPathInput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.EnableSfcIoamPotRenderedPathOutput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.EnableSfcIoamPotRenderedPathOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.SfcIoamNbPotService;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.TimeResolution;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SfcPotRpc
implements SfcIoamNbPotService {
    private static final Logger LOG = LoggerFactory.getLogger(SfcPotRpc.class);

    public static SfcPotRpc getSfcPotRpc() {
        return new SfcPotRpc();
    }

    public Future<RpcResult<EnableSfcIoamPotRenderedPathOutput>> enableSfcIoamPotRenderedPath(EnableSfcIoamPotRenderedPathInput input) {
        RpcResultBuilder rpcResultBuilder;
        RspName rspName = new RspName(input.getSfcIoamPotRspName());
        boolean ret = SfcPotRspProcessor.enableSfcPot(rspName, (Class<? extends TimeResolution>)input.getRefreshPeriodTimeUnits(), input.getRefreshPeriodValue(), input.getIoamPotBitMask(), input.getIoamPotNumProfiles());
        if (ret) {
            EnableSfcIoamPotRenderedPathOutputBuilder enableSfcIoamPotRenderedPathOutputBuilder = new EnableSfcIoamPotRenderedPathOutputBuilder();
            enableSfcIoamPotRenderedPathOutputBuilder.setResult(Boolean.valueOf(true));
            rpcResultBuilder = RpcResultBuilder.success((Object)enableSfcIoamPotRenderedPathOutputBuilder.build());
        } else {
            String message = "Error enabling SFC Proof of Transit for Rendered Service Path: " + rspName.getValue();
            rpcResultBuilder = RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, message);
        }
        return Futures.immediateFuture((Object)rpcResultBuilder.build());
    }

    public Future<RpcResult<DisableSfcIoamPotRenderedPathOutput>> disableSfcIoamPotRenderedPath(DisableSfcIoamPotRenderedPathInput input) {
        RpcResultBuilder rpcResultBuilder;
        RspName rspName = new RspName(input.getSfcIoamPotRspName());
        boolean ret = SfcPotRspProcessor.disableSfcPot(rspName);
        if (ret) {
            DisableSfcIoamPotRenderedPathOutputBuilder disableSfcIoamPotRenderedPathOutputBuilder = new DisableSfcIoamPotRenderedPathOutputBuilder();
            disableSfcIoamPotRenderedPathOutputBuilder.setResult(Boolean.valueOf(true));
            rpcResultBuilder = RpcResultBuilder.success((Object)disableSfcIoamPotRenderedPathOutputBuilder.build());
        } else {
            String message = "Error disabling SFC Proof of Transit for Rendered Service Path: " + rspName.getValue();
            rpcResultBuilder = RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, message);
        }
        return Futures.immediateFuture((Object)rpcResultBuilder.build());
    }
}

