/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.sfc.pot.provider;

import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.sfc.provider.api.SfcDataStoreAPI;
import org.opendaylight.sfc.provider.api.SfcProviderRenderedPathAPI;
import org.opendaylight.sfc.provider.api.SfcProviderServiceChainAPI;
import org.opendaylight.sfc.provider.api.SfcProviderServicePathAPI;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.RspName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SfcName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SfpName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.BitMaskOptions;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.RspIoamPotAugmentation;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.RspIoamPotAugmentationBuilder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.TimeResolution;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.RenderedServicePaths;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.rendered.service.paths.RenderedServicePath;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.rendered.service.paths.RenderedServicePathBuilder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.rendered.service.paths.RenderedServicePathKey;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfc.rev140701.service.function.chain.grouping.ServiceFunctionChain;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfp.rev140701.service.function.paths.ServiceFunctionPath;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SfcPotRspProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SfcPotRspProcessor.class);

    private SfcPotRspProcessor() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static boolean enableSfcPot(RenderedServicePath rsp, Class<? extends TimeResolution> refreshPeriodTimeUnits, Long refreshPeriodValue, BitMaskOptions ioamPotProfileBitMask, Long ioamPotNumProfiles) {
        ServiceFunctionChain serviceFunctionChain;
        RspIoamPotAugmentationBuilder rspIoamPotAugmentationBuilder = new RspIoamPotAugmentationBuilder();
        RenderedServicePathBuilder renderedServicePathBuilder = new RenderedServicePathBuilder(rsp);
        SfpName sfpName = rsp.getParentServiceFunctionPath();
        if (sfpName == null) {
            LOG.warn("iOAM:PoT:Enable:ServiceFunctionPath is invalid.");
            return false;
        }
        ServiceFunctionPath sfp = SfcProviderServicePathAPI.readServiceFunctionPath((SfpName)sfpName);
        SfcName serviceFunctionChainNameObj = sfp.getServiceChainName();
        ServiceFunctionChain serviceFunctionChain2 = serviceFunctionChain = serviceFunctionChainNameObj != null ? SfcProviderServiceChainAPI.readServiceFunctionChain((SfcName)serviceFunctionChainNameObj) : null;
        if (serviceFunctionChain == null) {
            LOG.error("iOAM:PoT:Enable:ServiceFunctionChain for Path:{} is invalid.", (Object)sfp.getName());
            return false;
        }
        rspIoamPotAugmentationBuilder.setIoamPotEnable(Boolean.valueOf(true));
        rspIoamPotAugmentationBuilder.setRefreshPeriodTimeUnits(refreshPeriodTimeUnits);
        rspIoamPotAugmentationBuilder.setRefreshPeriodValue(refreshPeriodValue);
        rspIoamPotAugmentationBuilder.setIoamPotBitMask(ioamPotProfileBitMask);
        rspIoamPotAugmentationBuilder.setIoamPotNumProfiles(ioamPotNumProfiles);
        renderedServicePathBuilder.removeAugmentation(RspIoamPotAugmentation.class);
        renderedServicePathBuilder.addAugmentation(RspIoamPotAugmentation.class, (Augmentation)rspIoamPotAugmentationBuilder.build());
        RenderedServicePathKey renderedServicePathKey = new RenderedServicePathKey(renderedServicePathBuilder.getName());
        InstanceIdentifier rspIID = InstanceIdentifier.builder(RenderedServicePaths.class).child(RenderedServicePath.class, (Identifier)renderedServicePathKey).build();
        RenderedServicePath renderedServicePath = renderedServicePathBuilder.build();
        if (!SfcDataStoreAPI.writeMergeTransactionAPI((InstanceIdentifier)rspIID, (DataObject)renderedServicePath, (LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL)) {
            LOG.warn("iOAM:PoT:Enable:{}:Failed to update Rendered Service Path:{}", (Object)Thread.currentThread().getStackTrace()[1], (Object)sfp.getName());
            return false;
        }
        LOG.debug("iOAM:PoT:Enable:Updated RSP: {}", (Object)sfp.getName());
        return true;
    }

    public static boolean enableSfcPot(RspName rspName, Class<? extends TimeResolution> refreshPeriodTimeUnits, Long refreshPeriodValue, BitMaskOptions ioamPotProfileBitMask, Long ioamPotNumProfiles) {
        RenderedServicePath rsp = SfcProviderRenderedPathAPI.readRenderedServicePath((RspName)rspName);
        if (rsp == null) {
            LOG.error("iOAM:PoT:Enable:Rendered service path by name:{} does not exist.", (Object)rspName);
            return false;
        }
        return SfcPotRspProcessor.enableSfcPot(rsp, refreshPeriodTimeUnits, refreshPeriodValue, ioamPotProfileBitMask, ioamPotNumProfiles);
    }

    public static boolean disableSfcPot(RspName rspName) {
        RenderedServicePath rsp = SfcProviderRenderedPathAPI.readRenderedServicePath((RspName)rspName);
        if (rsp == null) {
            LOG.error("iOAM:PoT:Disable:Rendered service path by name:{} does not exist.", (Object)rspName);
            return false;
        }
        return SfcPotRspProcessor.disableSfcPot(rsp);
    }

    public static boolean disableSfcPot(RenderedServicePath rsp) {
        ServiceFunctionChain serviceFunctionChain;
        RspIoamPotAugmentationBuilder rspIoamPotAugmentationBuilder = new RspIoamPotAugmentationBuilder();
        RenderedServicePathBuilder renderedServicePathBuilder = new RenderedServicePathBuilder(rsp);
        SfpName sfpName = rsp.getParentServiceFunctionPath();
        if (sfpName == null) {
            LOG.error("iOAM:PoT:Disable:ServiceFunctionPath:{} is invalid.", (Object)sfpName);
            return false;
        }
        ServiceFunctionPath sfp = SfcProviderServicePathAPI.readServiceFunctionPath((SfpName)sfpName);
        SfcName serviceFunctionChainNameObj = sfp.getServiceChainName();
        ServiceFunctionChain serviceFunctionChain2 = serviceFunctionChain = serviceFunctionChainNameObj != null ? SfcProviderServiceChainAPI.readServiceFunctionChain((SfcName)serviceFunctionChainNameObj) : null;
        if (serviceFunctionChain == null) {
            LOG.error("iOAM:PoT:Disable:ServiceFunctionChain name for Path {} is null.", (Object)sfp.getName());
            return false;
        }
        rspIoamPotAugmentationBuilder.setIoamPotEnable(Boolean.valueOf(false));
        renderedServicePathBuilder.removeAugmentation(RspIoamPotAugmentation.class);
        renderedServicePathBuilder.addAugmentation(RspIoamPotAugmentation.class, (Augmentation)rspIoamPotAugmentationBuilder.build());
        RenderedServicePathKey renderedServicePathKey = new RenderedServicePathKey(renderedServicePathBuilder.getName());
        InstanceIdentifier rspIID = InstanceIdentifier.builder(RenderedServicePaths.class).child(RenderedServicePath.class, (Identifier)renderedServicePathKey).build();
        RenderedServicePath renderedServicePath = renderedServicePathBuilder.build();
        if (!SfcDataStoreAPI.writeMergeTransactionAPI((InstanceIdentifier)rspIID, (DataObject)renderedServicePath, (LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL)) {
            LOG.warn("iOAM:PoT:Disable:{}:Failed to update Rendered Service Path: {}", (Object)Thread.currentThread().getStackTrace()[1], (Object)sfp.getName());
            return false;
        }
        LOG.debug("iOAM:PoT:Disable:Updated RSP: {}", (Object)sfp.getName());
        return true;
    }
}

