/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.tcpmd5.jni.cfg;

import javax.management.InstanceAlreadyExistsException;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.config.api.ConflictingVersionException;
import org.opendaylight.controller.config.api.ValidationException;
import org.opendaylight.controller.config.api.jmx.CommitStatus;
import org.opendaylight.controller.config.manager.impl.AbstractConfigTest;
import org.opendaylight.controller.config.manager.impl.factoriesresolver.HardcodedModuleFactoriesResolver;
import org.opendaylight.controller.config.manager.impl.factoriesresolver.ModuleFactoriesResolver;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.opendaylight.controller.config.util.ConfigTransactionJMXClient;
import org.opendaylight.controller.config.yang.tcpmd5.jni.cfg.NativeKeyAccessFactoryModuleFactory;
import org.opendaylight.tcpmd5.jni.NativeTestSupport;

public class NativeKeyAccessFactoryModuleTest
extends AbstractConfigTest {
    private static final String FACTORY_NAME = "native-key-access-factory";
    private static final String INSTANCE_NAME = "native-key-access-factory-instance";

    @Before
    public void setUp() throws Exception {
        super.initConfigTransactionManagerImpl((ModuleFactoriesResolver)new HardcodedModuleFactoriesResolver(this.mockedContext, new ModuleFactory[]{new NativeKeyAccessFactoryModuleFactory()}));
    }

    @Test
    public void testCreateBean() throws Exception {
        NativeTestSupport.assumeSupportedPlatform();
        CommitStatus status = this.createInstance();
        this.assertBeanCount(1, FACTORY_NAME);
        this.assertStatus(status, 1, 0, 0);
    }

    @Test
    public void testReusingOldInstance() throws Exception {
        NativeTestSupport.assumeSupportedPlatform();
        this.createInstance();
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        this.assertBeanCount(1, FACTORY_NAME);
        CommitStatus status = transaction.commit();
        this.assertBeanCount(1, FACTORY_NAME);
        this.assertStatus(status, 0, 0, 1);
    }

    private CommitStatus createInstance() throws ConflictingVersionException, ValidationException, InstanceAlreadyExistsException {
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        transaction.createModule(FACTORY_NAME, INSTANCE_NAME);
        return transaction.commit();
    }
}

