/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.tcpmd5.jni;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.tcpmd5.api.KeyAccess;
import org.opendaylight.tcpmd5.api.KeyAccessFactory;
import org.opendaylight.tcpmd5.api.KeyMapping;
import org.opendaylight.tcpmd5.jni.NativeKeyAccessFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicNativeKeyAccessTest {
    private static final Logger LOG = LoggerFactory.getLogger(BasicNativeKeyAccessTest.class);
    private static final byte[] KEY1 = new byte[]{1};
    private static final byte[] KEY2 = new byte[]{2, 3};
    private KeyAccessFactory factory;
    private Channel channel;

    private void testKeyManipulation(Channel c) throws IOException {
        Assert.assertTrue((boolean)this.factory.canHandleChannelClass(c.getClass()));
        KeyAccess ka = this.factory.getKeyAccess(c);
        Assert.assertEquals(Collections.emptyMap(), (Object)ka.getKeys());
        KeyMapping key1 = new KeyMapping();
        key1.put((Object)InetAddress.getLocalHost(), (Object)KEY1);
        LOG.debug("Setting key {}", (Object)KEY1);
        ka.setKeys(key1);
        Assert.assertEquals((Object)key1, (Object)ka.getKeys());
        ka.setKeys(key1);
        Assert.assertEquals((Object)key1, (Object)ka.getKeys());
        KeyMapping key2 = new KeyMapping();
        key2.put((Object)InetAddress.getLocalHost(), (Object)KEY2);
        LOG.debug("Setting key {}", (Object)KEY2);
        ka.setKeys(key2);
        Assert.assertEquals((Object)key2, (Object)ka.getKeys());
        LOG.debug("Deleting keys");
        ka.setKeys(new KeyMapping());
        Assert.assertEquals(Collections.emptyMap(), (Object)ka.getKeys());
    }

    @Before
    public void setup() throws IOException {
        this.factory = NativeKeyAccessFactory.getInstance();
        this.channel = SocketChannel.open();
    }

    @After
    public void teardown() throws IOException {
        this.channel.close();
    }

    @Test
    public void testSocket() throws IOException {
        this.testKeyManipulation(this.channel);
    }

    @Test(expected=NullPointerException.class)
    public void testNullChannel() {
        this.factory.getKeyAccess(null);
    }

    @Test(expected=NullPointerException.class)
    public void testNullClass() {
        this.factory.canHandleChannelClass(null);
    }

    @Test
    public void testServerSocket() throws IOException {
        try (ServerSocketChannel ssc = ServerSocketChannel.open();){
            this.testKeyManipulation(ssc);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testShortKey() throws IOException {
        KeyAccess ka = this.factory.getKeyAccess(this.channel);
        KeyMapping map = new KeyMapping();
        map.put((Object)InetAddress.getLocalHost(), (Object)new byte[0]);
        ka.setKeys(map);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLongKey() throws IOException {
        KeyAccess ka = this.factory.getKeyAccess(this.channel);
        KeyMapping map = new KeyMapping();
        map.put((Object)InetAddress.getLocalHost(), (Object)new byte[81]);
        ka.setKeys(map);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullAddress() throws IOException {
        KeyAccess ka = this.factory.getKeyAccess(this.channel);
        KeyMapping map = new KeyMapping();
        map.put(null, (Object)new byte[8]);
        ka.setKeys(map);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullKey() throws IOException {
        KeyAccess ka = this.factory.getKeyAccess(this.channel);
        KeyMapping map = new KeyMapping();
        map.put((Object)InetAddress.getLocalHost(), null);
        ka.setKeys(map);
    }

    @Test
    public void testUnsupportedChannel() throws IOException {
        try (DatagramChannel dc = DatagramChannel.open();){
            Assert.assertFalse((boolean)this.factory.canHandleChannelClass(dc.getClass()));
            Assert.assertNull((Object)this.factory.getKeyAccess((Channel)dc));
        }
    }
}

