/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.tcpmd5.jni;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.Channel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.tcpmd5.api.KeyAccess;
import org.opendaylight.tcpmd5.api.KeyAccessFactory;
import org.opendaylight.tcpmd5.api.KeyMapping;
import org.opendaylight.tcpmd5.jni.NativeKeyAccessFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectivityNativeKeyAccessTest {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectivityNativeKeyAccessTest.class);
    private static final byte[] KEY1 = new byte[]{1};
    private static final byte[] KEY2 = new byte[]{2, 3};
    private KeyAccessFactory factory;
    private Thread serverThread;
    private InetAddress address;
    private int port;
    private AtomicReference<SocketChannel> serverClient;

    @Before
    public void setup() throws IOException {
        this.factory = NativeKeyAccessFactory.getInstance();
        this.address = InetAddress.getLoopbackAddress();
        this.serverClient = new AtomicReference();
        final ServerSocketChannel sc = ServerSocketChannel.open();
        LOG.debug("Instatiated server {}", (Object)sc);
        KeyAccess ka = this.factory.getKeyAccess((Channel)sc);
        KeyMapping map = new KeyMapping();
        map.put((Object)this.address, (Object)KEY1);
        ka.setKeys(map);
        LOG.debug("Server got key {}", (Object)KEY1);
        sc.bind(new InetSocketAddress(this.address, 0));
        this.port = ((InetSocketAddress)sc.getLocalAddress()).getPort();
        LOG.debug("Server bound to port {}", (Object)this.port);
        this.serverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                LOG.debug("Server thread started");
                try {
                    SocketChannel s = sc.accept();
                    LOG.debug("Accepted channel {}", (Object)s);
                    ConnectivityNativeKeyAccessTest.this.serverClient.set(s);
                }
                catch (IOException e) {
                    LOG.debug("Failed to accept connection", (Throwable)e);
                }
            }
        });
        this.serverThread.start();
    }

    @After
    public void teardown() throws InterruptedException {
        this.serverThread.interrupt();
        this.serverThread.join();
    }

    @Test(timeout=2000L)
    public void testMatchingKey() throws IOException {
        try (SocketChannel c = SocketChannel.open();){
            KeyAccess ka = this.factory.getKeyAccess((Channel)c);
            KeyMapping map = new KeyMapping();
            map.put((Object)this.address, (Object)KEY1);
            ka.setKeys(map);
            c.connect(new InetSocketAddress(this.address, this.port));
            Assert.assertTrue((boolean)c.isConnected());
        }
    }

    @Test(timeout=5000L, expected=SocketTimeoutException.class)
    public void testMisatchedKey() throws IOException {
        try (SocketChannel c = SocketChannel.open();){
            KeyAccess ka = this.factory.getKeyAccess((Channel)c);
            KeyMapping map = new KeyMapping();
            map.put((Object)this.address, (Object)KEY2);
            ka.setKeys(map);
            c.socket().connect(new InetSocketAddress(this.address, this.port), 2000);
            Assert.assertFalse((boolean)c.isConnected());
        }
    }
}

