/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.usecpluginaaa.impl;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Scanner;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.usecpluginaaa.impl.PublishNotif;
import org.opendaylight.usecpluginaaa.impl.UsecpluginAAAStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsingLog
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(ParsingLog.class);
    public static DataBroker dataBroker;
    static RandomAccessFile reader;
    private static long sampleInterval;
    static File[] files;
    static File file;
    static File theNewestFile;
    static String workingDir;
    static String line;
    static String linetoRead;
    static String time;
    static String attempt;
    static String srcIP;
    static File infile;
    static String RevOrder_ofFiles;
    static String karafFiles;
    static String fileName;
    static Path karaffile;
    static String filetoread;
    static String WatchedDir;
    static long lengthBefore;
    static long length;
    private static boolean startAtBeginning;
    private static boolean tailing;
    UsecpluginAAAStore usecpluginAAAstore = new UsecpluginAAAStore();

    public DataBroker getdataBroker() {
        return dataBroker;
    }

    public void setdataBroker(DataBroker dataBroker) {
        ParsingLog.dataBroker = dataBroker;
    }

    public void parse() {
        this.usecpluginAAAstore.setdataBroker(dataBroker);
        try {
            this.getTheNewestFile();
            ParsingLog parsinglog = new ParsingLog();
            parsinglog.start();
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
    }

    public File getTheNewestFile() {
        workingDir = System.getProperty("user.dir");
        String fileName = workingDir + File.separator + "data" + File.separator + "log" + File.separator + "karaf.log";
        WatchedDir = workingDir + File.separator + "data" + File.separator + "log";
        try {
            int i;
            LOG.info("log enabled ...");
            File dir = new File(WatchedDir);
            Thread.sleep(10000L);
            files = dir.listFiles();
            Arrays.sort(files, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
            for (i = 0; i < files.length; ++i) {
                file = files[i];
                karafFiles = karafFiles + file.getName();
            }
            LOG.info("karaf files:" + karafFiles);
            Arrays.sort(files, LastModifiedFileComparator.LASTMODIFIED_REVERSE);
            for (i = 0; i < files.length; ++i) {
                file = files[i];
                RevOrder_ofFiles = RevOrder_ofFiles + file.getName();
            }
            LOG.info("list of karaf File in reverse order " + RevOrder_ofFiles);
            theNewestFile = files[0];
            LOG.info("Latest karaf File" + theNewestFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return theNewestFile;
    }

    @Override
    public void run() {
        long lengthBefore = 0L;
        long length = 0L;
        try {
            long filePointer = 0L;
            filePointer = startAtBeginning ? 0L : theNewestFile.length();
            tailing = true;
            reader = new RandomAccessFile(theNewestFile, "r");
            while (true) {
                if (tailing) {
                    long fileLength = theNewestFile.length();
                    if (fileLength < filePointer) {
                        reader = new RandomAccessFile(theNewestFile, "r");
                        filePointer = 0L;
                    }
                    if ((length = theNewestFile.length()) > lengthBefore) {
                        reader.seek(lengthBefore);
                        lengthBefore = length;
                        while ((linetoRead = reader.readLine()) != null) {
                            this.callData();
                        }
                        filePointer = reader.getFilePointer();
                    }
                    ParsingLog.sleep(sampleInterval);
                    reader.close();
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void callData() {
        workingDir = System.getProperty("user.dir");
        String fileName = workingDir + File.separator + "data" + File.separator + "log" + File.separator + "karaf.log";
        WatchedDir = workingDir + File.separator + "data" + File.separator + "log";
        try {
            LOG.info("log enabled ...");
            Thread.sleep(10000L);
            infile = new File(theNewestFile.toString());
            LOG.info("karaf file ..." + theNewestFile);
            Thread.sleep(1000L);
            LOG.info("parsing karaf file ...");
            Thread.sleep(9000L);
            Scanner scanner = new Scanner(infile);
            while (scanner.hasNext()) {
                line = scanner.nextLine();
                if (!line.contains("DEBUG") || !line.contains("from")) continue;
                String phrase1 = line;
                String delims = "[,]+";
                String[] tokens = phrase1.split(delims);
                String phrase2 = line;
                String delims2 = "[|]+";
                String[] tokens2 = phrase2.split(delims2);
                time = tokens[0];
                attempt = tokens2[5];
                String phrase3 = line;
                String[] parts = phrase3.split(" ");
                srcIP = parts[parts.length - 1];
                this.usecpluginAAAstore.addData(time, srcIP, attempt);
                LOG.info("Information stored in datastore is" + time + " " + srcIP + " " + attempt);
            }
            PublishNotif publishNotif = new PublishNotif();
            publishNotif.setdataBroker(dataBroker);
            publishNotif.Notify();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        reader = null;
        sampleInterval = 5000L;
        file = null;
        theNewestFile = null;
        time = "";
        attempt = "";
        srcIP = "";
        RevOrder_ofFiles = "";
        karafFiles = "";
        lengthBefore = 0L;
        length = 0L;
        startAtBeginning = false;
        tailing = false;
    }
}

